/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.dialog.wizard.api;

import com.atlassian.confluence.plugins.dialog.wizard.api.DialogWizard;
import com.atlassian.confluence.plugins.dialog.wizard.api.DialogWizardPage;
import com.atlassian.confluence.util.i18n.DocumentationBeanFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DialogWizardModuleDescriptor
extends AbstractModuleDescriptor<DialogWizard> {
    private final DocumentationBeanFactory documentationBeanFactory;
    private DialogWizard dialogWizard;

    public DialogWizardModuleDescriptor(@ComponentImport ModuleFactory moduleFactory, @ComponentImport DocumentationBeanFactory documentationBeanFactory) {
        super(moduleFactory);
        this.documentationBeanFactory = documentationBeanFactory;
    }

    public void init(@NonNull Plugin plugin, @NonNull Element element) throws PluginParseException {
        DialogWizardPage lastPage;
        super.init(plugin, element);
        ArrayList<DialogWizardPage> wizardPages = new ArrayList<DialogWizardPage>();
        for (Element child : element.elements("dialog-page")) {
            String descriptionHeaderLinkKey = child.attributeValue("description-header-link-key");
            String descriptionHeaderLink = child.attributeValue("description-header-link");
            if (StringUtils.isNotBlank((CharSequence)descriptionHeaderLinkKey)) {
                descriptionHeaderLink = this.documentationBeanFactory.getDocumentationBean().getLink(descriptionHeaderLinkKey);
            }
            DialogWizardPage page = new DialogWizardPage(child.attributeValue("id"), child.attributeValue("template-key"), child.attributeValue("title-key"), descriptionHeaderLink, child.attributeValue("description-header-key"), child.attributeValue("description-content-key"), child.attributeValue("last"));
            wizardPages.add(page);
        }
        if (!wizardPages.isEmpty() && (lastPage = (DialogWizardPage)wizardPages.get(wizardPages.size() - 1)).getLast() == null) {
            lastPage.setLast(true);
        }
        this.dialogWizard = new DialogWizard(this.getKey(), this.getI18nNameKey(), wizardPages);
    }

    public DialogWizard getModule() {
        return this.dialogWizard;
    }
}

