/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.dialog.wizard.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.plugins.dialog.wizard.api.DialogManager;
import com.atlassian.confluence.plugins.dialog.wizard.api.DialogWizard;
import com.atlassian.confluence.plugins.dialog.wizard.api.DialogWizardEntity;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.user.User;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.apache.commons.lang3.StringUtils;

@Path(value="/wizard")
@Produces(value={"application/json"})
public class DialogWizardResource {
    private static final String PARAM_DIALOG_KEY = "key";
    private final I18NBeanFactory i18NBeanFactory;
    private final LocaleManager localeManager;
    private final DialogManager dialogManager;

    @Inject
    public DialogWizardResource(@ComponentImport I18NBeanFactory i18NBeanFactory, @ComponentImport LocaleManager localeManager, DialogManager dialogManager) {
        this.i18NBeanFactory = i18NBeanFactory;
        this.localeManager = localeManager;
        this.dialogManager = dialogManager;
    }

    @GET
    @Path(value="/{key}")
    @AnonymousSiteAccess
    @ScopesAllowed(requiredScope={"READ"})
    public DialogWizardEntity getDialogWizardByKey(@PathParam(value="key") String dialogKey) {
        if (StringUtils.isBlank((CharSequence)dialogKey)) {
            return null;
        }
        DialogWizard dialogWizard = this.dialogManager.getDialogWizardByKey(dialogKey);
        I18NBean i18NBean = this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)AuthenticatedUserThreadLocal.get()));
        return new DialogWizardEntity(i18NBean, dialogWizard);
    }
}

