/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.serialblocklist.struts;

import com.atlassian.security.serialblocklist.BlocklistConfigurator;
import java.util.function.Predicate;
import ognl.Node;
import org.apache.struts2.ognl.StrutsOgnlGuard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlocklistAwareOgnlGuard
extends StrutsOgnlGuard {
    private final Logger LOG = LoggerFactory.getLogger(BlocklistAwareOgnlGuard.class);

    protected boolean checkNode(Node node) {
        Class<?> nodeClass = node.getClass();
        String nodeClassName = nodeClass.getName();
        if (!this.getBlocklistPredicate().test(nodeClass)) {
            this.LOG.warn("Expression contains blocked node type [{}]", (Object)nodeClassName);
            return true;
        }
        return super.checkNode(node);
    }

    protected boolean skipTreeCheck(Node tree) {
        return false;
    }

    Predicate<Class<?>> getBlocklistPredicate() {
        return BlocklistPredicateHolder.INSTANCE;
    }

    private static class BlocklistPredicateHolder {
        static final Predicate<Class<?>> INSTANCE = new BlocklistConfigurator().configure();

        private BlocklistPredicateHolder() {
        }
    }
}

