/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.serialblocklist.struts;

import com.atlassian.security.serialblocklist.BlocklistConfigurator;
import com.atlassian.security.serialblocklist.util.ClassUtil;
import java.lang.reflect.Member;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.struts2.inject.Inject;
import org.apache.struts2.ognl.ProviderAllowlist;
import org.apache.struts2.ognl.SecurityMemberAccess;
import org.apache.struts2.ognl.ThreadAllowlist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlocklistAwareSecureMembersAccess
extends SecurityMemberAccess {
    private static final Logger LOG = LoggerFactory.getLogger(BlocklistAwareSecureMembersAccess.class);

    @Inject
    public BlocklistAwareSecureMembersAccess(@Inject ProviderAllowlist providerAllowlist, @Inject ThreadAllowlist threadAllowlist) {
        super(providerAllowlist, threadAllowlist);
    }

    public boolean isAccessible(Map context, Object target, Member member, String propertyName) {
        if (!this.checkObject(target)) {
            LOG.warn("Blocked access to member [{}] of class [{}]", (Object)(member == null ? "" : member.getName()), (Object)target.getClass().getName());
            return false;
        }
        return super.isAccessible(context, target, member, propertyName);
    }

    private boolean checkObject(Object target) {
        return ClassUtil.checkObjectClass((Object)target, this.getBlocklistPredicate());
    }

    Predicate<Class<?>> getBlocklistPredicate() {
        return BlocklistPredicateHolder.INSTANCE;
    }

    private static class BlocklistPredicateHolder {
        static final Predicate<Class<?>> INSTANCE = new BlocklistConfigurator().configure();

        private BlocklistPredicateHolder() {
        }
    }
}

