/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.struts.httpmethod;

import java.util.Arrays;
import java.util.EnumSet;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum HttpMethod {
    GET{

        @Override
        public boolean matches(String methodName) {
            return super.matches(methodName) || HEAD.matches(methodName);
        }
    }
    ,
    POST,
    PUT,
    DELETE,
    HEAD,
    OPTIONS,
    TRACE,
    CONNECT,
    PROPFIND,
    PROPPATCH,
    MKCOL,
    COPY,
    MOVE,
    LOCK,
    UNLOCK,
    PATCH,
    ALL_RFC2616{

        @Override
        public boolean matches(String methodName) {
            return EnumSet.range(GET, CONNECT).stream().anyMatch(method -> method.matches(methodName));
        }
    }
    ,
    ALL_DEFINED{

        @Override
        public boolean matches(String methodName) {
            return EnumSet.range(GET, PATCH).stream().anyMatch(method -> method.matches(methodName));
        }
    }
    ,
    ANY_METHOD{

        @Override
        public boolean matches(String methodName) {
            return true;
        }
    };


    public boolean matches(String methodName) {
        return this.toString().equals(methodName);
    }

    public static boolean anyMatch(String methodName, HttpMethod ... httpMethods) {
        return Arrays.stream(httpMethods).anyMatch(allowedMethod -> allowedMethod.matches(methodName));
    }
}

