/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.struts.interceptor;

import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.struts2.ActionInvocation;
import org.apache.struts2.interceptor.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestrictHttpMethodInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(RestrictHttpMethodInterceptor.class);
    public static final String INVALID_METHOD_RESULT = "invalidmethod";
    public static final String PERMITTED_METHODS_PARAM_NAME = "permittedMethods";

    public String intercept(ActionInvocation invocation) throws Exception {
        Class<?> actionClass = invocation.getAction().getClass();
        String methodName = invocation.getProxy().getMethod();
        Method invocationMethod = actionClass.getMethod(methodName, new Class[0]);
        HttpMethod[] permittedMethods = this.getPermittedHttpMethods(invocation, invocationMethod);
        HttpServletRequest req = invocation.getInvocationContext().getServletRequest();
        String httpMethod = this.getHttpMethod(req);
        if (log.isDebugEnabled()) {
            log.debug("Checking HTTP method: {} permitted against {}", (Object)this.getHttpMethod(req), (Object)this.fullMethodName(invocationMethod));
        }
        if (this.getConfiguredSecurityLevel().isPermitted(invocationMethod.getName(), permittedMethods, httpMethod)) {
            log.debug("Invocation proceeding");
            return invocation.invoke();
        }
        log.info("Refusing HTTP method: {} against {} (configured allowed methods: {})", new Object[]{httpMethod, this.fullMethodName(invocationMethod), Arrays.toString((Object[])permittedMethods)});
        HttpServletResponse response = invocation.getInvocationContext().getServletResponse();
        if (response != null) {
            response.setHeader("Allow", Arrays.stream(permittedMethods).map(Enum::toString).collect(Collectors.joining(",")));
        }
        return INVALID_METHOD_RESULT;
    }

    protected HttpMethod[] getPermittedHttpMethods(ActionInvocation invocation, Method invocationMethod) {
        HttpMethod[] result = RestrictHttpMethodInterceptor.fromConfigParam(invocation);
        if (result != null) {
            return result;
        }
        result = RestrictHttpMethodInterceptor.fromAnnotation(invocationMethod);
        if (result != null) {
            return result;
        }
        return new HttpMethod[0];
    }

    private static HttpMethod[] fromConfigParam(ActionInvocation invocation) {
        String configParam = (String)invocation.getProxy().getConfig().getParams().get(PERMITTED_METHODS_PARAM_NAME);
        if (configParam == null || configParam.trim().isEmpty()) {
            return null;
        }
        String[] methodNames = configParam.trim().split("\\s*,\\s*");
        ArrayList<HttpMethod> permittedMethods = new ArrayList<HttpMethod>(methodNames.length);
        for (String methodName : methodNames) {
            try {
                permittedMethods.add(HttpMethod.valueOf(methodName));
            }
            catch (IllegalArgumentException e) {
                log.error("Struts configuration error: {} is not a recognised HTTP method (method names are case sensitive).", (Object)methodName);
            }
        }
        return permittedMethods.toArray(new HttpMethod[0]);
    }

    private static HttpMethod[] fromAnnotation(Method invocationMethod) {
        PermittedMethods annotation = invocationMethod.getAnnotation(PermittedMethods.class);
        if (annotation == null) {
            return null;
        }
        return annotation.value();
    }

    private String fullMethodName(Method invocationMethod) {
        return invocationMethod.getDeclaringClass().getName() + "#" + invocationMethod.getName();
    }

    private String getHttpMethod(HttpServletRequest servletRequest) {
        return servletRequest == null ? "" : servletRequest.getMethod();
    }

    public final void destroy() {
    }

    public final void init() {
    }

    protected SecurityLevel getConfiguredSecurityLevel() {
        return SecurityLevel.DEFAULT;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum SecurityLevel {
        DEFAULT{

            @Override
            public boolean isPermitted(String invocationMethodName, HttpMethod[] permittedMethods, String httpMethod) {
                if (permittedMethods.length == 0) {
                    if (invocationMethodName.equals("doDefault")) {
                        return HttpMethod.anyMatch(httpMethod, HttpMethod.GET, HttpMethod.POST);
                    }
                    return HttpMethod.anyMatch(httpMethod, HttpMethod.POST);
                }
                return HttpMethod.anyMatch(httpMethod, permittedMethods);
            }
        }
        ,
        STRICT{

            @Override
            public boolean isPermitted(String invocationMethodName, HttpMethod[] permittedMethods, String httpMethod) {
                return HttpMethod.anyMatch(httpMethod, permittedMethods);
            }
        };


        public abstract boolean isPermitted(String var1, HttpMethod[] var2, String var3);
    }
}

