/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.struts.interceptor;

import com.atlassian.util.profiling.ProfilingUtils;
import org.apache.struts2.ActionInvocation;
import org.apache.struts2.ActionProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;

class TransactionalInvocation {
    private static final Logger log = LoggerFactory.getLogger(TransactionalInvocation.class);
    private final TransactionAttribute transactionAttribute = new DefaultTransactionAttribute(0);
    private final PlatformTransactionManager transactionManager;
    private TransactionStatus transactionStatus;

    public TransactionalInvocation(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String invokeInTransaction(ActionInvocation invocation) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Creating transaction for action invocation: {}", (Object)this.getDetails(invocation));
        }
        this.setTransactionStatus(this.getNewTransaction());
        invocation.addPreResultListener((actionInvocation, s) -> {
            this.commitOrRollbackTransaction(invocation, false);
            if (log.isDebugEnabled()) {
                log.debug("Creating transaction for action result: {}", (Object)this.getDetails(invocation));
            }
            this.setTransactionStatus(this.getNewTransaction());
        });
        boolean swallowCommitErrors = true;
        try {
            String result = this.invokeAndHandleExceptions(invocation);
            swallowCommitErrors = false;
            String string = result;
            return string;
        }
        finally {
            this.commitOrRollbackTransaction(invocation, swallowCommitErrors);
        }
    }

    private String invokeAndHandleExceptions(ActionInvocation invocation) throws Exception {
        try {
            return invocation.invoke();
        }
        catch (Exception ex) {
            this.handleInvocationException(invocation, this.transactionAttribute, this.transactionStatus, ex);
            throw ex;
        }
    }

    private void commitOrRollbackTransaction(ActionInvocation actionInvocation, boolean swallowCommitErrors) {
        try {
            if (this.transactionStatus.isCompleted()) {
                log.error("Action {} is already completed and can not be committed again.", (Object)this.getDetails(actionInvocation));
            } else if (this.transactionStatus.isRollbackOnly()) {
                if (log.isDebugEnabled()) {
                    log.debug("Transaction status for action {} set to rollback only. Invoking rollback()", (Object)this.getDetails(actionInvocation));
                }
                this.transactionManager.rollback(this.transactionStatus);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Committing transaction for action {}", (Object)this.getDetails(actionInvocation));
                }
                this.transactionManager.commit(this.transactionStatus);
            }
        }
        catch (RuntimeException e) {
            if (swallowCommitErrors) {
                log.error("Commit/Rollback exception occurred but was swallowed", (Throwable)e);
            }
            throw e;
        }
    }

    private void handleInvocationException(ActionInvocation invocation, TransactionAttribute txAtt, TransactionStatus status, Throwable ex) {
        if (status == null) {
            return;
        }
        if (txAtt.rollbackOn(ex)) {
            log.info("Invoking rollback for transaction on action '{}' due to throwable: {}", new Object[]{this.getDetails(invocation), ex, ex});
            status.setRollbackOnly();
        } else if (log.isDebugEnabled()) {
            log.debug("Action {} threw exception {} but did not trigger a rollback.", new Object[]{invocation.getAction().getClass(), this.getDetails(invocation), ex});
        }
    }

    private TransactionStatus getNewTransaction() {
        return this.transactionManager.getTransaction((TransactionDefinition)this.transactionAttribute);
    }

    private void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    private String getDetails(ActionInvocation invocation) {
        ActionProxy proxy = invocation.getProxy();
        String methodName = proxy.getConfig().getMethodName();
        if (methodName == null) {
            methodName = "execute";
        }
        String actionClazz = ProfilingUtils.getJustClassName((String)proxy.getConfig().getClassName());
        return proxy.getNamespace() + "/" + proxy.getActionName() + ".action (" + actionClazz + "." + methodName + "())";
    }
}

