/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.struts.interceptor;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.xsrf.SimpleXsrfTokenGenerator;
import com.atlassian.struts.xsrf.XsrfProtectionRequired;
import com.atlassian.struts.xsrf.XsrfTokenGenerator;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import org.apache.struts2.ActionInvocation;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.action.Action;
import org.apache.struts2.interceptor.Interceptor;
import org.apache.struts2.interceptor.ValidationAware;

public class XsrfTokenInterceptor
implements Interceptor {
    public static final String REQUEST_PARAM_NAME = "atl_token";
    public static final String CONFIG_PARAM_NAME = "RequireSecurityToken";
    public static final String VALIDATION_FAILED_ERROR_KEY = "atlassian.xwork.xsrf.badtoken";
    public static final String SECURITY_TOKEN_REQUIRED_ERROR_KEY = "atlassian.xwork.xsrf.notoken";
    public static final String OVERRIDE_HEADER_NAME = "X-Atlassian-Token";
    public static final String OVERRIDE_HEADER_VALUE = "no-check";
    private final XsrfTokenGenerator tokenGenerator;

    public XsrfTokenInterceptor() {
        this(new SimpleXsrfTokenGenerator());
    }

    public XsrfTokenInterceptor(XsrfTokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        Method invocationMethod = XsrfTokenInterceptor.extractMethod(invocation);
        String configParam = (String)invocation.getProxy().getConfig().getParams().get(CONFIG_PARAM_NAME);
        XsrfProtectionRequired requiredAnnotation = invocationMethod.getAnnotation(XsrfProtectionRequired.class);
        XsrfProtectionExcluded excludedAnnotation = invocationMethod.getAnnotation(XsrfProtectionExcluded.class);
        boolean isProtected = this.methodRequiresProtection(configParam, requiredAnnotation, excludedAnnotation);
        String token = invocation.getInvocationContext().getServletRequest().getParameter(REQUEST_PARAM_NAME);
        boolean validToken = this.tokenGenerator.validateToken(invocation.getInvocationContext().getServletRequest(), token);
        if (isProtected && !validToken) {
            String errorMessageKey = token == null ? SECURITY_TOKEN_REQUIRED_ERROR_KEY : VALIDATION_FAILED_ERROR_KEY;
            this.addInvalidTokenError((Action)invocation.getAction(), errorMessageKey);
            invocation.getInvocationContext().getServletResponse().setStatus(403);
            return "input";
        }
        return invocation.invoke();
    }

    private static String getHttpMethod() {
        HttpServletRequest servletRequest = ServletActionContext.getRequest();
        return servletRequest == null ? "" : servletRequest.getMethod();
    }

    private static Method extractMethod(ActionInvocation invocation) throws NoSuchMethodException {
        Class<?> actionClass = invocation.getAction().getClass();
        String methodName = invocation.getProxy().getMethod();
        return actionClass.getMethod(methodName, new Class[0]);
    }

    private boolean methodRequiresProtection(String configParam, XsrfProtectionRequired requiredAnnotation, XsrfProtectionExcluded excludedAnnotation) {
        if (this.isOverrideHeaderPresent()) {
            return false;
        }
        if (requiredAnnotation != null) {
            return true;
        }
        if (excludedAnnotation != null) {
            return false;
        }
        if (configParam != null) {
            return Boolean.parseBoolean(configParam);
        }
        return this.getConfiguredSecurityLevel().getDefaultProtection();
    }

    protected void addInvalidTokenError(Action action, String errorMessageKey) {
        if (action instanceof ValidationAware) {
            ValidationAware validationAware = (ValidationAware)action;
            validationAware.addActionError(this.internationaliseErrorMessage(action, errorMessageKey));
        }
    }

    protected String internationaliseErrorMessage(Action action, String messageKey) {
        return messageKey;
    }

    private boolean isOverrideHeaderPresent() {
        return OVERRIDE_HEADER_VALUE.equals(ServletActionContext.getRequest().getHeader(OVERRIDE_HEADER_NAME));
    }

    public void destroy() {
    }

    public void init() {
    }

    protected SecurityLevel getConfiguredSecurityLevel() {
        return SecurityLevel.DEFAULT;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum SecurityLevel {
        OPT_OUT{

            @Override
            public boolean getDefaultProtection() {
                return true;
            }
        }
        ,
        DEFAULT{

            @Override
            public boolean getDefaultProtection() {
                String httpMethod = XsrfTokenInterceptor.getHttpMethod();
                return !HttpMethod.anyMatch(httpMethod, HttpMethod.GET, HttpMethod.HEAD, HttpMethod.OPTIONS, HttpMethod.TRACE);
            }
        };


        public abstract boolean getDefaultProtection();
    }
}

