/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.struts.multipart;

import com.atlassian.struts.multipart.AtlassianJakartaMultiPartRequest;
import com.atlassian.struts.multipart.FileUploadException;
import com.atlassian.struts.multipart.UploadedFile;
import com.atlassian.struts.multipart.impl.AtlassianJakartaMultiPartRequestWrapper;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.apache.struts2.dispatcher.LocalizedMessage;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MultiPartUtil {
    private MultiPartUtil() {
    }

    public static @Nullable AtlassianJakartaMultiPartRequest unwrapMultiPartRequest(HttpServletRequest request) {
        HttpServletRequestWrapper wrapped;
        ServletRequest servletRequest;
        if (request instanceof AtlassianJakartaMultiPartRequest) {
            return (AtlassianJakartaMultiPartRequest)request;
        }
        if (request instanceof MultiPartRequestWrapper) {
            MultiPartRequestWrapper strutsMultiPart = (MultiPartRequestWrapper)request;
            return new AtlassianJakartaMultiPartRequestWrapper(strutsMultiPart);
        }
        if (request instanceof HttpServletRequestWrapper && (servletRequest = (wrapped = (HttpServletRequestWrapper)request).getRequest()) instanceof HttpServletRequest) {
            HttpServletRequest delegate = (HttpServletRequest)servletRequest;
            return MultiPartUtil.unwrapMultiPartRequest(delegate);
        }
        return null;
    }

    public static UploadedFile getUploadedFile(HttpServletRequest request, String fileParameterName) throws FileUploadException {
        return MultiPartUtil.getUploadedFiles(request).stream().filter(uploadedFile -> uploadedFile.getParameterName().equals(fileParameterName)).findFirst().orElse(null);
    }

    public static List<UploadedFile> getUploadedFiles(HttpServletRequest request) throws FileUploadException {
        return MultiPartUtil.getUploadedFiles(request, true);
    }

    public static List<UploadedFile> getUploadedFiles(HttpServletRequest request, boolean ignoreMissingFiles) throws FileUploadException {
        AtlassianJakartaMultiPartRequest multiWrapper = MultiPartUtil.unwrapMultiPartRequest(request);
        if (multiWrapper == null) {
            return Collections.emptyList();
        }
        MultiPartUtil.throwIfMultiPartRequestHasErrors(multiWrapper);
        ArrayList<UploadedFile> uploadedFiles = new ArrayList<UploadedFile>();
        Enumeration e = multiWrapper.getFileParameterNames();
        ArrayList<LocalizedMessage> errors = new ArrayList<LocalizedMessage>();
        while (e.hasMoreElements()) {
            String inputValue = (String)e.nextElement();
            org.apache.struts2.dispatcher.multipart.UploadedFile[] files = multiWrapper.getFiles(inputValue);
            for (int i = 0; i < files.length; ++i) {
                org.apache.struts2.dispatcher.multipart.UploadedFile file = files[i];
                if (file == null) {
                    errors.add(new LocalizedMessage(MultiPartUtil.class, "struts.messages.error.uploading", "Error uploading " + multiWrapper.getFileSystemNames(inputValue)[i], new Object[]{multiWrapper.getFileSystemNames(inputValue)[i]}));
                    continue;
                }
                uploadedFiles.add(new UploadedFile(inputValue, new File(file.getAbsolutePath()), multiWrapper.getFileNames(inputValue)[i], multiWrapper.getContentTypes(inputValue)[i]));
            }
        }
        if (!ignoreMissingFiles && !errors.isEmpty()) {
            throw new FileUploadException(errors.toArray(new LocalizedMessage[0]));
        }
        return Collections.unmodifiableList(uploadedFiles);
    }

    public static void throwIfMultiPartRequestHasErrors(HttpServletRequest request) throws FileUploadException {
        AtlassianJakartaMultiPartRequest atlassianMultiPart = MultiPartUtil.unwrapMultiPartRequest(request);
        if (atlassianMultiPart == null || !atlassianMultiPart.hasErrors()) {
            return;
        }
        throw new FileUploadException(atlassianMultiPart.getErrors().toArray(new LocalizedMessage[0]));
    }
}

