/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.struts.result;

import com.rometools.rome.feed.WireFeed;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.WireFeedOutput;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import org.apache.struts2.ActionInvocation;
import org.apache.struts2.result.StrutsResultSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RssResult
extends StrutsResultSupport {
    private static final Logger log = LoggerFactory.getLogger(RssResult.class);
    private static final String DEFAULT_DEFAULT_ENCODING = "UTF-8";
    public static final String RSS = "rss";
    public static final String RSS1 = "rss1";
    public static final String RSS2 = "rss2";
    public static final String ATOM = "atom";

    protected void doExecute(String finalDestination, ActionInvocation actionInvocation) throws Exception {
        block7: {
            actionInvocation.getInvocationContext().getServletRequest().getSession(false);
            HttpServletResponse response = actionInvocation.getInvocationContext().getServletResponse();
            if (finalDestination.startsWith(RSS)) {
                response.setContentType("application/rss+xml; charset=UTF-8");
            } else if (finalDestination.startsWith(ATOM)) {
                response.setContentType("application/atom+xml; charset=UTF-8");
            } else {
                response.setContentType("text/xml; charset=UTF-8");
            }
            SyndFeed feed = (SyndFeed)actionInvocation.getStack().findValue("syndFeed");
            if (feed == null) {
                throw new ServletException("Unable to find feed for this action");
            }
            WireFeed outFeed = feed.createWireFeed(finalDestination);
            outFeed.setEncoding(DEFAULT_DEFAULT_ENCODING);
            new WireFeedOutput().output(outFeed, (Writer)response.getWriter());
            try {
                response.flushBuffer();
            }
            catch (IOException e) {
                log.info("Client aborted (closed the connection) before the rss feed could be returned.");
                if (!log.isDebugEnabled()) break block7;
                log.debug("Error sending rss result to client", (Throwable)e);
            }
        }
    }
}

