/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.struts.xsrf;

import com.atlassian.security.random.DefaultSecureTokenGenerator;
import com.atlassian.struts.xsrf.XsrfTokenGenerator;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;

public class SimpleXsrfTokenGenerator
implements XsrfTokenGenerator {
    public static final String TOKEN_SESSION_KEY = "atlassian.xsrf.token";

    @Override
    public String getToken(HttpServletRequest request, boolean create) {
        HttpSession session = request.getSession();
        String token = (String)session.getAttribute(TOKEN_SESSION_KEY);
        if (create && token == null) {
            token = this.createToken();
            session.setAttribute(TOKEN_SESSION_KEY, (Object)token);
        }
        return token;
    }

    @Override
    public String generateToken(HttpServletRequest request) {
        return this.getToken(request, true);
    }

    @Override
    public String getXsrfTokenName() {
        return "atl_token";
    }

    @Override
    public boolean validateToken(HttpServletRequest request, String token) {
        return token != null && token.equals(request.getSession(true).getAttribute(TOKEN_SESSION_KEY));
    }

    private String createToken() {
        return DefaultSecureTokenGenerator.getInstance().generateToken();
    }
}

