/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.emoticons.rest;

import com.atlassian.confluence.plugins.hipchat.emoticons.audit.event.CustomEmojiUploadDisabledAuditEvent;
import com.atlassian.confluence.plugins.hipchat.emoticons.audit.event.CustomEmojiUploadEnabledAuditEvent;
import com.atlassian.confluence.plugins.hipchat.emoticons.service.AdminConfigurationService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AdminOnly
@Path(value="/admin")
public class AdminResource {
    private static final Logger log = LoggerFactory.getLogger(AdminResource.class);
    private final AdminConfigurationService adminConfigurationService;
    private final EventPublisher eventPublisher;

    @Inject
    public AdminResource(AdminConfigurationService adminConfigurationService, EventPublisher eventPublisher) {
        this.adminConfigurationService = adminConfigurationService;
        this.eventPublisher = eventPublisher;
    }

    @POST
    @Path(value="/user-upload-emoji/{isChecked}")
    public Response setUserUploadEmojis(@PathParam(value="isChecked") String isChecked) {
        log.debug("Will set user upload emojis with param={}", (Object)isChecked);
        this.adminConfigurationService.setAllowUserUploadCustomEmojis(Boolean.parseBoolean(isChecked));
        if (Boolean.parseBoolean(isChecked)) {
            this.eventPublisher.publish((Object)new CustomEmojiUploadEnabledAuditEvent());
        } else {
            this.eventPublisher.publish((Object)new CustomEmojiUploadDisabledAuditEvent());
        }
        return Response.ok().build();
    }
}

