/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.emoticons.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.plugins.hipchat.emoticons.rest.AtlaskitEmoticonModel;
import com.atlassian.confluence.plugins.hipchat.emoticons.service.ConfluenceEmoticonService;
import com.atlassian.confluence.plugins.hipchat.emoticons.service.CustomEmoticonService;
import com.atlassian.confluence.plugins.hipchat.emoticons.service.TwitterEmoticonService;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class EmoticonsResource {
    private static final Logger log = LoggerFactory.getLogger(EmoticonsResource.class);
    private final ConfluenceEmoticonService confluenceEmoticonService;
    private final CustomEmoticonService customEmoticonService;
    private final TwitterEmoticonService twitterEmoticonService;
    private static final String INVALID_FILE_TYPE = "INVALID_FILE_TYPE";

    @Inject
    public EmoticonsResource(@Named(value="customEmoticonService") CustomEmoticonService customEmoticonService, @Named(value="twitterEmoticonService") TwitterEmoticonService twitterEmoticonService, ConfluenceEmoticonService confluenceEmoticonService) {
        this.customEmoticonService = customEmoticonService;
        this.twitterEmoticonService = twitterEmoticonService;
        this.confluenceEmoticonService = confluenceEmoticonService;
    }

    @GET
    @AnonymousSiteAccess
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Map<String, Object> get() {
        ArrayList<AtlaskitEmoticonModel> atlaskitEmoticonModels = new ArrayList<AtlaskitEmoticonModel>();
        atlaskitEmoticonModels.addAll(this.confluenceEmoticonService.orderedList());
        atlaskitEmoticonModels.addAll(this.twitterEmoticonService.list());
        return ImmutableMap.builder().put((Object)"emojis", (Object)atlaskitEmoticonModels.toArray()).build();
    }
}

