/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.emoticons.rest;

import com.atlassian.confluence.plugins.hipchat.emoticons.exception.EmoticonGenerateThumbnailException;
import com.atlassian.confluence.plugins.hipchat.emoticons.exception.EmoticonValidationException;
import com.atlassian.confluence.rest.v2.api.model.ExceptionConverter;
import com.atlassian.confluence.rest.v2.api.model.RestError;
import jakarta.annotation.Priority;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;

@Priority(value=2000)
@Provider
public class RestExceptionMapper
implements ExceptionMapper<Exception> {
    public final Response toResponse(Exception exception) {
        if (exception instanceof WebApplicationException) {
            WebApplicationException web = (WebApplicationException)exception;
            return web.getResponse();
        }
        if (exception instanceof EmoticonValidationException) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)exception.getMessage()).build();
        }
        if (exception instanceof EmoticonGenerateThumbnailException) {
            return Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).entity((Object)"EMOTICON_GENERATE_THUMBNAIL_EXCEPTION").build();
        }
        RestError errorBean = ExceptionConverter.Server.convertServiceException((Exception)exception);
        return Response.status((int)errorBean.getStatusCode()).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)errorBean).build();
    }
}

