/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.emoticons.rest;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.plugins.hipchat.emoticons.rest.AtlaskitEmoticonModel;
import com.atlassian.confluence.plugins.hipchat.emoticons.service.TwitterEmoticonService;
import com.atlassian.confluence.web.filter.CachingHeaders;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Qualifier;

@AnonymousSiteAccess
public class TwitterEmojiRedirectorServlet
extends HttpServlet {
    TwitterEmoticonService twitterEmoticonService;

    public TwitterEmojiRedirectorServlet(@Qualifier(value="twitterEmoticonService") TwitterEmoticonService twitterEmoticonService) {
        this.twitterEmoticonService = twitterEmoticonService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        CachingHeaders.PUBLIC_LONG_TERM.apply(resp);
        String id = req.getParameter("id");
        this.doGetCache(id, resp);
    }

    public void doGetCache(String id, HttpServletResponse resp) throws IOException {
        AtlaskitEmoticonModel model = this.twitterEmoticonService.findById(id);
        if (model == null) {
            resp.setStatus(404);
            return;
        }
        resp.setContentType("image/svg+xml");
        resp.getWriter().write(this.twitterEmoticonService.getImageFileContent(model));
    }
}

