/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.emoticons.rest.interceptor;

import com.atlassian.confluence.plugins.hipchat.emoticons.rest.interceptor.CustomEmojisUploadPermission;
import com.atlassian.confluence.plugins.hipchat.emoticons.service.AdminConfigurationService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.permission.AuthorisationException;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=8000)
@Provider
@CustomEmojisUploadPermission
public class CustomEmojiPermissionInterceptor
implements ReaderInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(CustomEmojiPermissionInterceptor.class);
    private final AdminConfigurationService adminConfigurationService;
    private final UserManager userManager;

    @Inject
    public CustomEmojiPermissionInterceptor(AdminConfigurationService adminConfigurationService, @ComponentImport UserManager userManager) {
        this.adminConfigurationService = adminConfigurationService;
        this.userManager = userManager;
    }

    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        boolean currentUserIsAdminOrSystemAdmin;
        if (this.adminConfigurationService.isAllowUserUploadCustomEmojis()) {
            logger.debug("All users are allowed to upload custom emojis.");
            return context.proceed();
        }
        logger.debug("Only admins are able to upload custom emojis.");
        UserKey currentLoginUser = this.userManager.getRemoteUserKey();
        boolean bl = currentUserIsAdminOrSystemAdmin = this.userManager.isSystemAdmin(currentLoginUser) || this.userManager.isAdmin(currentLoginUser);
        if (!currentUserIsAdminOrSystemAdmin) {
            throw new AuthorisationException();
        }
        return context.proceed();
    }
}

