/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.internal.applinks;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.streams.internal.applinks.ApplicationLinkServiceExtensions;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Response;

@LicensedOnly
@Path(value="/applinks/status")
public class ApplinkAuthStatusResource {
    private static final CacheControl NO_CACHE = new CacheControl();
    private final ApplicationLinkService appLinkService;
    private final ApplicationLinkServiceExtensions appLinkServiceExtensions;

    @Inject
    public ApplinkAuthStatusResource(ApplicationLinkService appLinkService, ApplicationLinkServiceExtensions appLinkServiceExtensions) {
        this.appLinkService = (ApplicationLinkService)Preconditions.checkNotNull((Object)appLinkService, (Object)"appLinkService");
        this.appLinkServiceExtensions = (ApplicationLinkServiceExtensions)Preconditions.checkNotNull((Object)appLinkServiceExtensions, (Object)"appLinkServiceExtensions");
    }

    @GET
    @Path(value="/{applinkId}")
    @Produces(value={"application/json"})
    public Response getApplinkAvailability(@PathParam(value="applinkId") String applinkId) {
        ApplicationLink appLink;
        try {
            appLink = this.appLinkService.getApplicationLink(new ApplicationId(applinkId));
        }
        catch (TypeNotInstalledException e) {
            appLink = null;
        }
        Response.ResponseBuilder response = appLink == null ? Response.status((Response.Status)Response.Status.NOT_FOUND) : (this.appLinkServiceExtensions.isAuthorised(appLink) ? Response.ok() : Response.status((Response.Status)Response.Status.FORBIDDEN));
        return response.cacheControl(NO_CACHE).build();
    }

    static {
        NO_CACHE.setNoStore(true);
        NO_CACHE.setNoCache(true);
    }
}

