/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.internal.applinks;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.streams.internal.applinks.ApplicationLinkServiceExtensionsImpl;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class OAuthCompletionServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(OAuthCompletionServlet.class);
    public static final String APPLINK_ID_PARAM = "applinkId";
    private static final Pattern APPLINK_ID_REGEX = Pattern.compile("[0-9a-z-]+");
    private static final String TEMPLATE = "streams.applinks.authCompletion";
    private final ApplicationLinkService appLinkService;
    private final ApplicationLinkServiceExtensionsImpl appLinkServiceExtensionsImpl;
    private final SoyTemplateRenderer soyTemplateRenderer;

    public OAuthCompletionServlet(ApplicationLinkService appLinkService, ApplicationLinkServiceExtensionsImpl appLinkServiceExtensionsImpl, SoyTemplateRenderer soyTemplateRenderer) {
        this.appLinkService = (ApplicationLinkService)Preconditions.checkNotNull((Object)appLinkService, (Object)"appLinkService");
        this.appLinkServiceExtensionsImpl = (ApplicationLinkServiceExtensionsImpl)Preconditions.checkNotNull((Object)appLinkServiceExtensionsImpl, (Object)"appLinkServiceExtensionsImpl");
        this.soyTemplateRenderer = (SoyTemplateRenderer)Preconditions.checkNotNull((Object)soyTemplateRenderer, (Object)"soyTemplateRenderer");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ApplicationLink appLink;
        String applinkId = request.getParameter(APPLINK_ID_PARAM);
        if (applinkId == null || !APPLINK_ID_REGEX.matcher(applinkId).matches()) {
            response.setStatus(400);
            return;
        }
        boolean success = false;
        try {
            appLink = this.appLinkService.getApplicationLink(new ApplicationId(applinkId));
            if (appLink != null) {
                success = this.appLinkServiceExtensionsImpl.isAuthorised(appLink);
            }
        }
        catch (TypeNotInstalledException e) {
            log.error("Unknown applink type for applink ID '" + applinkId + "'");
            appLink = null;
        }
        ImmutableMap context = ImmutableMap.of((Object)APPLINK_ID_PARAM, (Object)applinkId, (Object)"authAdminUri", (Object)(appLink == null ? "" : this.appLinkServiceExtensionsImpl.getUserAdminUri(appLink).toString()), (Object)"success", (Object)success);
        response.setContentType("text/html");
        this.soyTemplateRenderer.render((Appendable)response.getWriter(), "com.atlassian.streams:auth-completion-resources", TEMPLATE, (Map)context);
    }
}

