/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.internal.rest.resources;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.streams.internal.ConfigRepresentationBuilder;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Response;

@Path(value="/config")
@UnrestrictedAccess
public class StreamsConfigResource {
    private static final CacheControl NO_CACHE = new CacheControl();
    private final ConfigRepresentationBuilder representationBuilder;

    @Inject
    public StreamsConfigResource(ConfigRepresentationBuilder representationBuilder) {
        this.representationBuilder = (ConfigRepresentationBuilder)Preconditions.checkNotNull((Object)representationBuilder, (Object)"representationBuilder");
    }

    @GET
    @Produces(value={"application/vnd.atl.streams+json"})
    public Response getFilters(@QueryParam(value="local") boolean local) {
        return Response.ok((Object)this.representationBuilder.getConfigRepresentation(local)).type("application/vnd.atl.streams+json").cacheControl(NO_CACHE).build();
    }

    static {
        NO_CACHE.setNoStore(true);
        NO_CACHE.setNoCache(true);
    }
}

