/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.internal.rest.resources;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import com.atlassian.streams.api.StreamsException;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.api.common.uri.Uri;
import com.atlassian.streams.internal.ActivityProviders;
import com.atlassian.streams.internal.AppLinksActivityProvider;
import com.atlassian.streams.internal.rest.resources.whitelist.Whitelist;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import javax.annotation.Nullable;

@LicensedOnly
@Path(value="url-proxy")
public class UrlProxyResource {
    private final ActivityProviders activityProviders;
    private final Whitelist whitelist;

    @Inject
    public UrlProxyResource(ActivityProviders activityProviders, Whitelist whitelist) {
        this.activityProviders = (ActivityProviders)Preconditions.checkNotNull((Object)activityProviders, (Object)"activityProviders");
        this.whitelist = (Whitelist)Preconditions.checkNotNull((Object)whitelist, (Object)"whitelist");
    }

    @GET
    public Response get(@QueryParam(value="url") String url) {
        return this.execute(url, Request.MethodType.GET, null);
    }

    @POST
    @Consumes(value={"application/json"})
    public Response post(@QueryParam(value="url") String url) {
        return this.execute(url, Request.MethodType.POST, "application/json");
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response put(@QueryParam(value="url") String url) {
        return this.execute(url, Request.MethodType.PUT, "application/json");
    }

    private Response execute(String url, Request.MethodType methodType, @Nullable String contentType) {
        Uri uri = Uri.parse((String)url);
        if (!this.whitelist.allows(uri.toJavaUri())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"").build();
        }
        Option<AppLinksActivityProvider> provider = this.activityProviders.getRemoteProviderForUri(uri);
        try {
            Response response;
            if (!provider.isDefined()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"").build();
            }
            Request<?, com.atlassian.sal.api.net.Response> request = ((AppLinksActivityProvider)provider.get()).createRequest(url, methodType);
            request.setFollowRedirects(false);
            if (contentType != null) {
                request.addHeader("Content-Type", contentType);
            }
            if (401 == (response = this.executeRequest(request)).getStatus()) {
                return this.retryRequestAsAnonymous((AppLinksActivityProvider)provider.get(), url, methodType);
            }
            return response;
        }
        catch (CredentialsRequiredException cre) {
            return this.retryRequestAsAnonymous((AppLinksActivityProvider)provider.get(), url, methodType);
        }
    }

    private Response retryRequestAsAnonymous(AppLinksActivityProvider provider, String url, Request.MethodType methodType) {
        try {
            return this.executeRequest(provider.createAnonymousRequest(url, methodType));
        }
        catch (CredentialsRequiredException cre) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"").build();
        }
    }

    private Response executeRequest(Request<?, com.atlassian.sal.api.net.Response> request) {
        try {
            return Response.status((int)((com.atlassian.sal.api.net.Response)request.executeAndReturn((ReturningResponseHandler)new ProxyResponseHandler(this))).getStatusCode()).entity((Object)"").build();
        }
        catch (ResponseException e) {
            throw new StreamsException((Throwable)e);
        }
    }

    private final class ProxyResponseHandler
    implements ReturningResponseHandler<com.atlassian.sal.api.net.Response, com.atlassian.sal.api.net.Response> {
        private ProxyResponseHandler(UrlProxyResource urlProxyResource) {
        }

        public com.atlassian.sal.api.net.Response handle(com.atlassian.sal.api.net.Response response) throws ResponseException {
            return response;
        }
    }
}

