/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.config;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.extra.flyingpdf.config.FontManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.platform.security.file.FileContentProvider;
import com.atlassian.platform.security.file.FileMetadata;
import com.atlassian.platform.security.file.FileSafetyChecker;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.struts.multipart.UploadedFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

@AdminOnly
public class ConfigurePDFLanguageSupportAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(ConfigurePDFLanguageSupportAction.class);
    private FontManager pdfExportFontManager;
    private boolean installFontSuccess = false;

    public String execute() throws Exception {
        List uploadedFiles = this.strutsHelper.getUploadedFiles(this.getActiveRequest());
        if (uploadedFiles.isEmpty()) {
            this.addActionError(this.getText("pdf.font.error.nofile"));
            return "error";
        }
        final UploadedFile uploadedFile = (UploadedFile)uploadedFiles.get(0);
        if (!this.fileChecksPassed(uploadedFile)) {
            this.addActionError(this.getText("pdf.font.error.other"));
            return "error";
        }
        try {
            String extension = FilenameUtils.getExtension((String)uploadedFile.getFileName());
            if (!extension.equals("ttf") && !extension.equals("ttc")) {
                this.addActionError(this.getText("pdf.error.file.extension"));
                return "error";
            }
            if (!uploadedFile.getContentType().equals("font/ttf") && !uploadedFile.getContentType().equals("application/octet-stream")) {
                this.addActionError(this.getText("pdf.font.error.contenttype"));
                return "error";
            }
            if (!this.isValidFileContentType(uploadedFile.getFile())) {
                return "error";
            }
            this.pdfExportFontManager.installFont((Resource)new FileSystemResource(uploadedFile.getFile()){

                public String getFilename() {
                    return uploadedFile.getFileName();
                }
            });
        }
        catch (Exception ex) {
            log.error("Unable to install language font.", (Throwable)ex);
            this.addActionError(ex.getMessage());
            return "error";
        }
        return "success";
    }

    private boolean fileChecksPassed(UploadedFile uploadedFile) {
        if (this.beforeUploadFileCheck(uploadedFile)) {
            try {
                if (this.afterUploadFileCheck(uploadedFile)) {
                    return true;
                }
            }
            catch (IOException e) {
                log.error("Error during after upload file check", (Throwable)e);
            }
        }
        return false;
    }

    private File saveFontToTemporaryLocation(UploadedFile uploadedFile) throws IOException {
        File tempFile = File.createTempFile("temp-", uploadedFile.getFileName());
        try (FileInputStream inputStream = new FileInputStream(uploadedFile.getFile());){
            Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        return tempFile;
    }

    private boolean beforeUploadFileCheck(UploadedFile uploadedFile) {
        FileMetadata fileMetadata = new FileMetadata(uploadedFile.getFileName(), uploadedFile.getFile().length(), "text/plain");
        List expectedTypes = List.of();
        Collection validationErrors = FileSafetyChecker.validateBeforeUpload((FileMetadata)fileMetadata, (long)-1L, (boolean)true, expectedTypes);
        return validationErrors.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean afterUploadFileCheck(UploadedFile uploadedFile) throws IOException {
        final File tempFile = this.saveFontToTemporaryLocation(uploadedFile);
        FileContentProvider contentProvider = new FileContentProvider(){

            public <T> T processFile(FileContentProvider.ThrowingFunction<InputStream, T, IOException> fileProcessor) throws IOException {
                try (FileInputStream inputStream = new FileInputStream(tempFile);){
                    Object object = fileProcessor.apply((Object)inputStream);
                    return (T)object;
                }
            }
        };
        List expectedTypes = List.of();
        boolean validationPassed = false;
        try {
            Collection validationErrors = FileSafetyChecker.validateAfterUpload((FileContentProvider)contentProvider, expectedTypes);
            validationPassed = validationErrors.isEmpty();
        }
        catch (Exception e) {
            log.error("Error validating file after upload", (Throwable)e);
        }
        finally {
            Files.delete(tempFile.toPath());
        }
        return validationPassed;
    }

    private boolean isValidFileContentType(File file) throws Exception {
        try (FileInputStream inputStream = new FileInputStream(file);){
            AutoDetectParser parser = new AutoDetectParser();
            BodyContentHandler handler = new BodyContentHandler();
            Metadata metadata = new Metadata();
            ParseContext context = new ParseContext();
            parser.parse(inputStream, handler, metadata, context);
            if (!metadata.get("Content-Type").equals("application/x-font-ttf") && !metadata.get("Content-Type").equals("application/octet-stream")) {
                this.addActionError(this.getText("pdf.font.error.content"));
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String doRestoreDefault() {
        try {
            this.pdfExportFontManager.removeInstalledFont();
        }
        catch (IOException ex) {
            log.error("Unable to remove custom font.", (Throwable)ex);
            this.addActionError(ex.getMessage());
            return "error";
        }
        return "success";
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }

    public String getInstalledFontName() {
        FileSystemResource fontResource = this.pdfExportFontManager.getInstalledFont();
        if (fontResource != null) {
            return fontResource.getFilename();
        }
        return null;
    }

    public boolean isInstallFontSuccess() {
        return this.installFontSuccess;
    }

    @StrutsParameter
    public void setInstallFontSuccess(boolean installFontSuccess) {
        this.installFontSuccess = installFontSuccess;
    }

    public void setPdfExportFontManager(FontManager pdfExportFontManager) {
        this.pdfExportFontManager = pdfExportFontManager;
    }
}

