/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.config;

import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.confluence.extra.flyingpdf.config.CustomFontInstalledEvent;
import com.atlassian.confluence.extra.flyingpdf.config.CustomFontRemovedEvent;
import com.atlassian.confluence.extra.flyingpdf.config.FontDao;
import com.atlassian.event.api.EventListener;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class CustomFontClusterEventListener {
    private static final Logger log = LoggerFactory.getLogger(CustomFontClusterEventListener.class);
    private FontDao fontDao;

    @EventListener
    public void handleEvent(ClusterEventWrapper clusterEventWrapper) {
        clusterEventWrapper.unwrapIfType(CustomFontInstalledEvent.class).ifPresent(this::handleInstallEvent);
        clusterEventWrapper.unwrapIfType(CustomFontRemovedEvent.class).ifPresent(this::handleRemoveEvent);
    }

    private void handleRemoveEvent(CustomFontRemovedEvent event) {
        try {
            this.fontDao.removeFont(event.getFontName());
        }
        catch (IOException e) {
            log.error("Unable to remove custom PDF font: {} - {}", new Object[]{event.getFontName(), e.getMessage(), e});
        }
    }

    private void handleInstallEvent(CustomFontInstalledEvent event) {
        ByteArrayResource resource = new ByteArrayResource(event.getFontData());
        try {
            this.fontDao.saveFont(event.getFontName(), (Resource)resource);
        }
        catch (IOException ex) {
            log.error("Unable to install custom PDF font: {} - {}", new Object[]{event.getFontName(), ex.getMessage(), ex});
        }
    }

    public void setPdfExportFontsDirectoryFontDao(FontDao pdfExportFontsDirectoryFontDao) {
        this.fontDao = pdfExportFontsDirectoryFontDao;
    }
}

