/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.config;

import com.atlassian.confluence.extra.flyingpdf.config.PdfExportSettingsManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultPdfExportSettingsManager
implements PdfExportSettingsManager {
    private static final String STYLESHEET_KEY = "com.atlassian.confluence.extra.flyingpdf.config.style";
    private static final String TITLEPAGE_KEY = "com.atlassian.confluence.extra.flyingpdf.config.titlepage";
    private static final String HEADER_KEY = "com.atlassian.confluence.extra.flyingpdf.config.header";
    private static final String FOOTER_KEY = "com.atlassian.confluence.extra.flyingpdf.config.footer";
    private static final Logger log = LoggerFactory.getLogger(DefaultPdfExportSettingsManager.class);
    private final PluginSettingsFactory pluginSettingsFactory;

    public DefaultPdfExportSettingsManager(@ComponentImport PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    @Override
    public String getStyle(String namespace) {
        return this.getSettingsOrFallbackToGlobalDefault(namespace, STYLESHEET_KEY);
    }

    @Override
    public void setStyle(String namespace, String value) {
        value = this.nullOutIfEmpty(value);
        this.pluginSettingsFactory.createSettingsForKey(namespace).put(STYLESHEET_KEY, (Object)value);
    }

    @Override
    public String getFooter(String namespace) {
        return this.getSettingsOrFallbackToGlobalDefault(namespace, FOOTER_KEY);
    }

    @Override
    public String getHeader(String namespace) {
        return this.getSettingsOrFallbackToGlobalDefault(namespace, HEADER_KEY);
    }

    @Override
    public String getTitlePage(String namespace) {
        return this.getSettingsOrFallbackToGlobalDefault(namespace, TITLEPAGE_KEY);
    }

    @Override
    public void setFooter(String namespace, String value) {
        value = this.nullOutIfEmpty(value);
        this.pluginSettingsFactory.createSettingsForKey(namespace).put(FOOTER_KEY, (Object)value);
    }

    @Override
    public void setHeader(String namespace, String value) {
        value = this.nullOutIfEmpty(value);
        this.pluginSettingsFactory.createSettingsForKey(namespace).put(HEADER_KEY, (Object)value);
    }

    @Override
    public void setTitlePage(String namespace, String value) {
        value = this.nullOutIfEmpty(value);
        this.pluginSettingsFactory.createSettingsForKey(namespace).put(TITLEPAGE_KEY, (Object)value);
    }

    private String getSettingsOrFallbackToGlobalDefault(String namespace, String key) {
        String value = (String)this.pluginSettingsFactory.createSettingsForKey(namespace).get(key);
        return StringUtils.isNotEmpty((CharSequence)value) || namespace == null ? value : (String)this.pluginSettingsFactory.createGlobalSettings().get(key);
    }

    private String nullOutIfEmpty(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            value = null;
        }
        return value;
    }
}

