/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.config;

import com.atlassian.confluence.extra.flyingpdf.config.FontDao;
import com.atlassian.core.util.FileUtils;
import com.atlassian.dc.filestore.api.compat.FilesystemPath;
import com.atlassian.dc.filestore.impl.filesystem.FilesystemFileStore;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class FontsDirectoryFontDao
implements FontDao {
    public static final String FONTS_DIR = "fonts";
    private final ApplicationProperties applicationProperties;
    private final FilesystemFileStore filesystemFileStore;

    public FontsDirectoryFontDao(@ComponentImport ApplicationProperties applicationProperties) throws IOException {
        this.applicationProperties = applicationProperties;
        this.filesystemFileStore = new FilesystemFileStore(this.getBaseFontsDir().toPath());
    }

    @Override
    public Resource getFont(String fontName) throws IOException {
        File fontFile = this.filesystemFileStore.path(fontName).asJavaFile();
        if (!fontFile.exists()) {
            throw new IOException("No font file could be found with the name " + fontName);
        }
        return new FileSystemResource(fontFile);
    }

    @Override
    public void saveFont(String fontName, Resource fontResource) throws IOException {
        this.saveFont(fontName, fontResource, true);
    }

    @Override
    public void saveFont(String fontName, Resource fontResource, boolean overwrite) throws IOException {
        if (!fontResource.exists()) {
            throw new IOException("Attempting to install a font resource that does not exist: " + fontResource.getDescription());
        }
        FilesystemPath installedFont = this.filesystemFileStore.path(fontName);
        try (InputStream istream = fontResource.getInputStream();){
            FileUtils.copyFile((InputStream)istream, (File)installedFont.asJavaFile(), (boolean)overwrite);
        }
    }

    @Override
    public void removeFont(String fontName) throws IOException {
        FileSystemResource fontResource = (FileSystemResource)this.getFont(fontName);
        File fontFile = fontResource.getFile();
        if (!fontFile.delete()) {
            throw new IOException("Failed to remove the font file " + fontFile.getAbsolutePath());
        }
    }

    private File getBaseFontsDir() throws IOException {
        File fontDir = new File(this.applicationProperties.getHomeDirectory(), FONTS_DIR);
        if (!fontDir.exists() && !fontDir.mkdir()) {
            throw new IOException("Failed to create the font directory " + fontDir.getAbsolutePath());
        }
        return fontDir;
    }
}

