/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.config;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.extra.flyingpdf.config.AbstractConfigurePdfExportAction;
import com.atlassian.confluence.extra.flyingpdf.config.OutboundConnectionValidator;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import java.util.stream.Stream;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.jsoup.Jsoup;
import org.jsoup.select.Elements;

@AdminOnly
public class GlobalConfigurePdfExportLayout
extends AbstractConfigurePdfExportAction {
    private String header;
    private String footer;
    private String titlePage;
    private boolean hasSSRFError = false;
    protected OutboundConnectionValidator outboundConnectionValidator;

    public void setOutboundConnectionValidator(OutboundConnectionValidator outboundConnectionValidator) {
        this.outboundConnectionValidator = outboundConnectionValidator;
    }

    @StrutsParameter
    public void setTitlePage(String titlePage) {
        this.titlePage = titlePage;
    }

    public String getTitlePage() {
        return this.pdfSettings.getTitlePage(this.getPluginSettingsNamespace());
    }

    @StrutsParameter
    public void setHeader(String header) {
        this.header = header;
    }

    public String getHeader() {
        return this.pdfSettings.getHeader(this.getPluginSettingsNamespace());
    }

    @StrutsParameter
    public void setFooter(String footer) {
        this.footer = footer;
    }

    public String getFooter() {
        return this.pdfSettings.getFooter(this.getPluginSettingsNamespace());
    }

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    @XsrfProtectionExcluded
    public String execute() {
        return "success";
    }

    public String doEdit() {
        if (!this.IsSSRFCheckPassed()) {
            return "error";
        }
        this.pdfSettings.setTitlePage(this.getPluginSettingsNamespace(), this.titlePage);
        this.pdfSettings.setHeader(this.getPluginSettingsNamespace(), this.header);
        this.pdfSettings.setFooter(this.getPluginSettingsNamespace(), this.footer);
        return "success";
    }

    private boolean IsSSRFCheckPassed() {
        Stream.of(this.titlePage, this.header, this.footer).forEach(this::checkSSRFAgainstElementSrc);
        return !this.hasSSRFError;
    }

    private void checkSSRFAgainstElementSrc(String html) throws IllegalArgumentException, ServiceException {
        Stream.of("audio", "embed", "iframe", "img", "input", "script", "track", "video").forEach(tag -> {
            Elements elements = Jsoup.parseBodyFragment((String)html).getElementsByTag(tag);
            if (elements.isEmpty()) {
                return;
            }
            elements.stream().filter(element -> element.hasAttr("src")).forEach(element -> {
                OutboundConnectionValidator.ValidateResult result = this.outboundConnectionValidator.validate(element.attr("src").trim());
                if (!result.isValid()) {
                    this.hasSSRFError = true;
                    if (!this.getActionErrors().contains(result.getErrorMessage())) {
                        this.addActionError(result.getErrorMessage());
                    }
                }
            });
        });
    }
}

