/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.html;

import com.atlassian.confluence.extra.flyingpdf.util.UrlUtils;
import com.atlassian.renderer.util.UrlUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class LinkFixer {
    private final HashMap<String, String> pageTitleById = new HashMap();
    private final HashSet<String> pageTitles = new HashSet();
    private final String baseUrl;
    private final String spaceKey;
    private final InternalPageStrategy pageStrategy;

    public LinkFixer(String spaceKey, String baseUrl, InternalPageStrategy pageStrategy) {
        this.baseUrl = LinkFixer.trimEndingSlash(baseUrl);
        this.spaceKey = spaceKey;
        this.pageStrategy = pageStrategy;
    }

    void addPage(String pageId, String pageTitle) {
        this.pageTitleById.put(pageId, pageTitle);
        this.pageTitles.add(pageTitle);
    }

    String convertLink(String url) {
        boolean isOnThisServer;
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        boolean bl = isOnThisServer = url.trim().startsWith("/") || url.trim().startsWith(this.baseUrl);
        if (!isOnThisServer) {
            return null;
        }
        String viewPageUrl = this.getLinkFromViewPageUrl(url);
        return viewPageUrl != null ? viewPageUrl : this.getLinkFromViewPageActionUrl(url);
    }

    private String getLinkFromViewPageActionUrl(String url) {
        if (url.contains("/pages/viewpage.action?")) {
            Map queryParams = UrlUtil.getQueryParameters((String)url);
            String urlSpaceKey = (String)queryParams.get("spaceKey");
            String pageId = (String)queryParams.get("pageId");
            String title = UrlUtils.decode((String)queryParams.get("pageTitle"));
            if (pageId != null) {
                title = this.pageTitleById.get(pageId);
                if (title != null) {
                    return this.pageStrategy.generate(this.baseUrl, this.spaceKey, pageId, title);
                }
            } else if (this.spaceKey.equalsIgnoreCase(urlSpaceKey) && this.pageTitles.contains(title)) {
                return this.pageStrategy.generate(this.baseUrl, urlSpaceKey, pageId, title);
            }
        }
        return null;
    }

    private String getLinkFromViewPageUrl(String url) {
        Matcher matcher = UrlUtils.pageDisplayUrlPattern.matcher(url);
        if (matcher.find()) {
            String urlSpaceKey = matcher.group(1);
            String pageTitleId = matcher.group(2);
            if (UrlUtils.encode(this.spaceKey).equalsIgnoreCase(urlSpaceKey) && this.pageTitleById.containsKey(pageTitleId)) {
                return this.pageStrategy.generate(this.baseUrl, urlSpaceKey, pageTitleId, this.pageTitleById.get(pageTitleId));
            }
        }
        return null;
    }

    private static String trimEndingSlash(String baseUrl) {
        return baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum InternalPageStrategy {
        ANCHOR{

            @Override
            String generate(String baseUrl, String spaceKey, String id, String title) {
                return "#" + title;
            }
        }
        ,
        NORMALISE{

            @Override
            String generate(String baseUrl, String spaceKey, String id, String title) {
                return baseUrl + "/spaces/" + UrlUtils.encode(spaceKey) + "/pages/" + UrlUtils.encode(id) + "/" + UrlUtils.encode(title);
            }
        };


        abstract String generate(String var1, String var2, String var3, String var4);
    }
}

