/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.html;

import com.atlassian.confluence.extra.flyingpdf.util.UrlUtils;
import java.util.ArrayList;
import java.util.List;

public class TocBuilder {
    private final String baseUrl;
    private final String spaceKey;
    private final List<TocEntry> entries = new ArrayList<TocEntry>();

    public TocBuilder() {
        this(null, null);
    }

    public TocBuilder(String baseUrl, String spaceKey) {
        this.baseUrl = baseUrl;
        this.spaceKey = spaceKey;
    }

    public void addEntry(int level, String pageTitle, String pageId) {
        this.entries.add(new TocEntry(level, pageTitle, pageId));
    }

    public void addEntry(int level, String pageTitle, String pageId, int pageLocation) {
        this.entries.add(new TocEntry(level, pageTitle, pageId, pageLocation));
    }

    public List<TocEntry> getEntries() {
        return this.entries;
    }

    public class TocEntry {
        private final int level;
        private final String title;
        private final String id;
        private final int pageLocation;

        TocEntry(int level, String title, String id) {
            this(level, title, id, 0);
        }

        TocEntry(int level, String title, String id, int pageLocation) {
            this.level = level;
            this.title = title;
            this.id = id;
            this.pageLocation = pageLocation;
        }

        public int getLevel() {
            return this.level;
        }

        public String getTitle() {
            return this.title;
        }

        public String getFullUrl() {
            return TocBuilder.this.baseUrl + "/spaces/" + TocBuilder.this.spaceKey + "/pages/" + UrlUtils.encode(this.id) + "/" + UrlUtils.encode(this.title);
        }

        public int getPageLocation() {
            return this.pageLocation;
        }
    }
}

