/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.impl;

import com.atlassian.confluence.extra.flyingpdf.impl.LightITextFSImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.net.URLCodec;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.pdf.ITextUserAgent;
import org.xhtmlrenderer.resource.ImageResource;

public abstract class AbstractExportUserAgent
extends ITextUserAgent {
    private static final String FILE_PREFIX = "file:";
    private static final String DATA_PREFIX = "data:";
    private static final Pattern RESOURCE_PATH_PATTERN = Pattern.compile("/s/(.*)/_/");
    private static final int EXTERNAL_IMG_DOWNLOAD_TIMEOUT = Integer.getInteger("pdf.export.sandbox.external.img.timeout.secs", 10);
    private final ExecutorService executorService = Executors.newFixedThreadPool(1);
    private final String baseUrl;
    private final String cdnUrl;
    private final int dotsPerPixel;
    private final boolean bypassCdn = !Boolean.getBoolean("pdf.export.allow.cdn.access");

    public AbstractExportUserAgent(ITextOutputDevice device, String baseUrl, @Nullable String cdnUrl, int dotsPerPixel) {
        super(device, dotsPerPixel);
        this.baseUrl = baseUrl;
        this.cdnUrl = cdnUrl;
        this.dotsPerPixel = dotsPerPixel;
    }

    @Override
    public ImageResource getImageResource(String uri) {
        try {
            return new ImageResource(uri, new LightITextFSImage(() -> this.resolveAndOpenStream(uri), this.dotsPerPixel, this.baseUrl, uri));
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Can't get image resource for uri" + uri + ", error: " + e.getMessage());
            return new ImageResource(null, null);
        }
    }

    @Override
    protected InputStream resolveAndOpenStream(String uri) {
        String relativeUri;
        if (uri == null) {
            return null;
        }
        if (this.shrinkImageCacheBeforeFetching()) {
            this.shrinkImageCache();
        }
        String effectiveUri = uri;
        if (this.bypassCdn && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.cdnUrl) && effectiveUri.startsWith(this.cdnUrl)) {
            effectiveUri = effectiveUri.replace(this.cdnUrl, this.baseUrl);
        }
        if ((relativeUri = effectiveUri).startsWith(FILE_PREFIX)) {
            relativeUri = relativeUri.substring(FILE_PREFIX.length());
        } else if (relativeUri.startsWith(this.baseUrl)) {
            relativeUri = relativeUri.substring(this.baseUrl.length());
        }
        Matcher matcher = RESOURCE_PATH_PATTERN.matcher(relativeUri);
        relativeUri = matcher.replaceFirst("/");
        String decodedUri = URLDecoder.decode(relativeUri, StandardCharsets.UTF_8);
        InputStream resource = this.fetchResourceFromConfluence(relativeUri, decodedUri);
        if (resource != null) {
            return resource;
        }
        if (effectiveUri.startsWith(DATA_PREFIX)) {
            return this.streamDataUrl(effectiveUri);
        }
        return this.resolveAndOpenStreamWithTimeout(effectiveUri);
    }

    protected InputStream pdfResolveAndOpenStream(String uri) {
        return super.resolveAndOpenStream(uri);
    }

    protected int getExternalImgDownloadTimeout() {
        return EXTERNAL_IMG_DOWNLOAD_TIMEOUT;
    }

    protected InputStream resolveAndOpenStreamWithTimeout(String uri) throws RuntimeException {
        Future<InputStream> future = this.executorService.submit(() -> {
            InputStream is = this.pdfResolveAndOpenStream(uri);
            if (Thread.currentThread().isInterrupted()) {
                is.close();
                this.log(Level.SEVERE, "Closing rogue open stream after timeout to uri: " + uri);
            }
            return is;
        });
        try {
            return future.get(this.getExternalImgDownloadTimeout(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.log(Level.SEVERE, "InterruptedException when resolving and opening stream for uri: " + uri);
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.log(Level.SEVERE, "ExecutionException when resolving and opening stream for uri: " + uri);
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            this.log(Level.SEVERE, "TimeoutException when resolving and opening stream for uri: " + uri + " after " + EXTERNAL_IMG_DOWNLOAD_TIMEOUT + " seconds");
            future.cancel(true);
            throw new RuntimeException(e);
        }
    }

    protected boolean shrinkImageCacheBeforeFetching() {
        return false;
    }

    protected abstract InputStream fetchResourceFromConfluence(String var1, String var2);

    private InputStream streamDataUrl(String dataUrl) {
        byte[] bytes;
        int dataIndex = dataUrl.indexOf(44);
        String data = dataUrl.substring(dataIndex + 1);
        if (dataUrl.substring(0, dataIndex).endsWith(";base64")) {
            bytes = Base64.decodeBase64((String)data);
        } else {
            try {
                bytes = URLCodec.decodeUrl((byte[])StringUtils.getBytesUsAscii((String)data));
            }
            catch (DecoderException e) {
                throw new IllegalArgumentException("Invalid data URL: \"" + dataUrl + "\".", e);
            }
        }
        return new ByteArrayInputStream(bytes);
    }

    protected void log(Level level, String message) {
    }
}

