/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.impl;

import com.atlassian.confluence.api.model.Depth;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.dmz.importexport.LegacyImportExportManager;
import com.atlassian.confluence.extra.flyingpdf.PdfExporterService;
import com.atlassian.confluence.extra.flyingpdf.impl.ExportPermissionChecker;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import java.util.Optional;

public abstract class AbstractPdfExporterService
implements PdfExporterService {
    protected final SpaceService apiSpaceService;
    protected final LegacyImportExportManager importExportManager;
    protected final ExportPermissionChecker exportPermissionChecker;

    public AbstractPdfExporterService(SpaceService apiSpaceService, LegacyImportExportManager importExportManager, ExportPermissionChecker exportPermissionChecker) {
        this.apiSpaceService = apiSpaceService;
        this.importExportManager = importExportManager;
        this.exportPermissionChecker = exportPermissionChecker;
    }

    @Override
    public ContentTree getContentTree(ConfluenceUser user, Space space) {
        return this.importExportManager.getContentTree((User)user, space);
    }

    @Override
    public boolean isPermitted(ConfluenceUser user, AbstractPage page) {
        return this.exportPermissionChecker.isPermitted(user, page);
    }

    @Override
    public boolean isPermitted(ConfluenceUser user, Space space) {
        return this.exportPermissionChecker.isPermitted(user, space);
    }

    @Override
    public boolean exportableContentExists(Space space) {
        if (space == null) {
            return false;
        }
        Optional modelSpace = this.apiSpaceService.find(new Expansion[0]).withKeys(new String[]{space.getKey()}).fetch();
        return modelSpace.isPresent() && this.apiSpaceService.findContent((com.atlassian.confluence.api.model.content.Space)modelSpace.get(), new Expansion[0]).withDepth(Depth.ROOT).fetchMany(ContentType.PAGE, (PageRequest)new SimplePageRequest(0, 10)).size() > 0;
    }
}

