/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.impl;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.extra.flyingpdf.PdfExporterService;
import com.atlassian.confluence.extra.flyingpdf.html.DecorationPolicy;
import com.atlassian.confluence.extra.flyingpdf.impl.BigBrotherPdfExporterService;
import com.atlassian.confluence.extra.flyingpdf.impl.PdfExportLongRunningTask;
import com.atlassian.confluence.extra.flyingpdf.impl.PdfExportLongRunningTaskFactory;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

@AnonymousSiteAccess
public class BetterExportSpaceAction
extends AbstractSpaceAction {
    public static final String CONTENT_OPTION_CUSTOM_EXPORT = "visible";
    protected PdfExportLongRunningTaskFactory pdfExportLongRunningTaskFactory;
    protected PdfExporterService pdfExporterService;
    protected LongRunningTaskId taskId;
    protected LongRunningTaskManager longRunningTaskManager;
    protected String downloadPath;
    private List<String> contentToBeExported;
    private String contentOption;
    private boolean addPageNumbers;
    private PermissionManager permissionManager;

    public String doExport() {
        List<String> contentToBeExported = StringUtils.equals((CharSequence)this.contentOption, (CharSequence)CONTENT_OPTION_CUSTOM_EXPORT) ? this.getContentToBeExported() : null;
        PdfExportLongRunningTask task = this.pdfExportLongRunningTaskFactory.createNewLongRunningTask(contentToBeExported, this.getSpace(), this.getAuthenticatedUser(), this.getActiveRequest().getContextPath(), this.getDecorations());
        this.taskId = this.longRunningTaskManager.startLongRunningTask(this.getAuthenticatedUser(), (LongRunningTask)task);
        return "success";
    }

    public String execute() {
        return this.doExport();
    }

    public boolean isPermitted() {
        UtilTimerStack.push((String)"BetterExportSpaceAction.isPermitted");
        boolean isPermitted = this.pdfExporterService.isPermitted(this.getAuthenticatedUser(), this.getSpace());
        UtilTimerStack.pop((String)"BetterExportSpaceAction.isPermitted");
        return isPermitted;
    }

    public boolean exportableContentExists() {
        UtilTimerStack.push((String)"BetterExportSpaceAction.exportableContentExists");
        boolean containsStuff = this.pdfExporterService.exportableContentExists(this.getSpace());
        UtilTimerStack.pop((String)"BetterExportSpaceAction.exportableContentExists");
        return containsStuff;
    }

    private DecorationPolicy getDecorations() {
        return this.addPageNumbers ? DecorationPolicy.pageNumbers() : DecorationPolicy.none();
    }

    public String getSpaceAdvancedUrl() {
        return "/spaces/viewspacesummary.action?key=" + this.getHelper().getSpaceKey();
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }

    public List<String> getContentToBeExported() {
        return this.contentToBeExported;
    }

    @StrutsParameter
    public void setContentToBeExported(List<String> contentToBeExported) {
        this.contentToBeExported = contentToBeExported;
    }

    @StrutsParameter
    public void setContentOption(String contentOption) {
        this.contentOption = contentOption;
    }

    @StrutsParameter
    public void setAddPageNumbers(boolean addPageNumbers) {
        this.addPageNumbers = addPageNumbers;
    }

    public boolean isSpaceAdmin() {
        return this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.ADMINISTER, (Object)this.getSpace());
    }

    public LongRunningTaskId getTaskId() {
        return this.taskId;
    }

    public void setPdfExportLongRunningTaskFactory(PdfExportLongRunningTaskFactory pdfExportLongRunningTaskFactory) {
        this.pdfExportLongRunningTaskFactory = pdfExportLongRunningTaskFactory;
    }

    public void setDiagnosticsPdfExporterService(BigBrotherPdfExporterService diagnosticsPdfExporterService) {
        this.pdfExporterService = diagnosticsPdfExporterService;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setLongRunningTaskManager(LongRunningTaskManager longRunningTaskManager) {
        this.longRunningTaskManager = longRunningTaskManager;
    }
}

