/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.impl;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.content.render.xhtml.ConversionContextOutputType;
import com.atlassian.confluence.extra.flyingpdf.analytic.PageExportMetrics;
import com.atlassian.confluence.extra.flyingpdf.impl.BigBrotherPdfExporterService;
import com.atlassian.confluence.extra.flyingpdf.impl.PdfExportSemaphore;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.pages.actions.AbstractPageAwareAction;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.setup.settings.ConfluenceDirectories;
import com.atlassian.confluence.user.persistence.dao.compatibility.FindUserHelper;
import com.atlassian.confluence.util.OutputTypeThreadLocal;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.user.User;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousSiteAccess
public class ExportPageAsPdfAction
extends AbstractPageAwareAction {
    private static final Logger log = LoggerFactory.getLogger(ExportPageAsPdfAction.class);
    private GateKeeper gateKeeper;
    private String downloadPath;
    private BigBrotherPdfExporterService pdfExporterService;
    private PdfExportSemaphore pdfExportSemaphore;
    private ConfluenceDirectories confluenceDirectories;

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String execute() {
        try {
            OutputTypeThreadLocal.set((ConversionContextOutputType)ConversionContextOutputType.PDF);
            this.pdfExportSemaphore.run(this::doExecute);
            String string = "download";
            return string;
        }
        finally {
            OutputTypeThreadLocal.clear();
        }
    }

    private void doExecute() {
        try {
            String contextPath = this.getActiveRequest().getContextPath();
            File exportedDocument = this.pdfExporterService.createPdfForPage(this.getAuthenticatedUser(), this.getPage(), contextPath, new PageExportMetrics());
            String rawPath = this.prepareDownloadPath(exportedDocument);
            this.downloadPath = this.addPdfContentTypeParam(this.replaceBackslashes(this.encodePath(rawPath)));
            String gatekeeperPath = this.replaceBackslashes(rawPath);
            Predicate<User> permissionPredicate = u -> this.permissionManager.hasPermission(FindUserHelper.getUser((User)u), Permission.VIEW, (Object)this.getPage());
            this.gateKeeper.addKey(gatekeeperPath, (User)this.getAuthenticatedUser(), permissionPredicate);
        }
        catch (ImportExportException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isPermitted() {
        return this.pdfExporterService.isPermitted(this.getAuthenticatedUser(), this.getPage());
    }

    private String prepareDownloadPath(File file) throws IOException {
        String exportDir = this.confluenceDirectories.getTempDirectory().toString();
        String canonicalPath = file.getCanonicalPath();
        int exportDirIndex = canonicalPath.indexOf(exportDir);
        String urlPath = null;
        if (exportDirIndex != -1) {
            urlPath = canonicalPath.substring(exportDirIndex + exportDir.length());
        } else {
            for (File root : File.listRoots()) {
                String rootPath = root.getCanonicalPath();
                int rootIndex = canonicalPath.indexOf(rootPath);
                if (rootIndex == -1) continue;
                urlPath = canonicalPath.substring(rootIndex + rootPath.length());
                break;
            }
            if (urlPath == null) {
                log.warn("Path to the download [ {} ] has not been stripped of any parent directories, and may be invalid", (Object)file);
                urlPath = file.getPath();
            }
        }
        return "/download/export" + urlPath;
    }

    private String addPdfContentTypeParam(String url) {
        return url + "?contentType=application/pdf";
    }

    private String replaceBackslashes(String relativeFilePath) {
        return relativeFilePath.replaceAll("\\\\", "/");
    }

    private String encodePath(String urlPath) throws UnsupportedEncodingException {
        int lastSlash = ((String)urlPath).lastIndexOf(File.separator);
        String prefix = "";
        if (lastSlash != -1) {
            prefix = ((String)urlPath).substring(0, lastSlash);
        }
        String suffix = ((String)urlPath).substring(lastSlash + 1);
        String encodedSuffix = URLEncoder.encode(suffix, StandardCharsets.UTF_8);
        urlPath = lastSlash != -1 ? prefix + "/" + encodedSuffix : encodedSuffix;
        return urlPath;
    }

    public void setGateKeeper(GateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }

    public void setDiagnosticsPdfExporterService(BigBrotherPdfExporterService pdfExporterService) {
        this.pdfExporterService = pdfExporterService;
    }

    public void setPdfExportSemaphore(PdfExportSemaphore pdfExportSemaphore) {
        this.pdfExportSemaphore = pdfExportSemaphore;
    }

    public void setConfluenceDirectories(ConfluenceDirectories confluenceDirectories) {
        this.confluenceDirectories = confluenceDirectories;
    }
}

