/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.impl;

import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.dmz.importexport.LegacyImportExportManager;
import com.atlassian.confluence.extra.flyingpdf.PdfExportProgressMonitor;
import com.atlassian.confluence.extra.flyingpdf.analytic.ExportStatus;
import com.atlassian.confluence.extra.flyingpdf.analytic.PageExportMetrics;
import com.atlassian.confluence.extra.flyingpdf.analytic.SpaceExportMetrics;
import com.atlassian.confluence.extra.flyingpdf.html.DecorationPolicy;
import com.atlassian.confluence.extra.flyingpdf.html.LinkRenderingDetails;
import com.atlassian.confluence.extra.flyingpdf.html.XhtmlBuilder;
import com.atlassian.confluence.extra.flyingpdf.impl.AbstractPdfExportProgressMonitor;
import com.atlassian.confluence.extra.flyingpdf.impl.AbstractPdfExporterService;
import com.atlassian.confluence.extra.flyingpdf.impl.DefaultProgressMonitor;
import com.atlassian.confluence.extra.flyingpdf.impl.ExportPermissionChecker;
import com.atlassian.confluence.extra.flyingpdf.impl.FlyingSaucerXmlToPdfConverter;
import com.atlassian.confluence.extra.flyingpdf.impl.ProgressMeterWrappingProgressMonitor;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.ContentNode;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.FilesystemUtils;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.util.profiling.UtilTimerStack;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.Optional;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;

@Component
public class InternalPdfExporterService
extends AbstractPdfExporterService {
    private final I18NBeanFactory i18NBeanFactory;
    private final XhtmlBuilder intermediateHtmlBuilder;
    private final FlyingSaucerXmlToPdfConverter flyingPdfDocumentConverter;

    public InternalPdfExporterService(@ComponentImport I18NBeanFactory i18NBeanFactory, @ComponentImport SpaceService apiSpaceService, @ComponentImport LegacyImportExportManager importExportManager, XhtmlBuilder intermediateHtmlBuilder, ExportPermissionChecker exportPermissionChecker, FlyingSaucerXmlToPdfConverter flyingPdfDocumentConverter) {
        super(apiSpaceService, importExportManager, exportPermissionChecker);
        this.i18NBeanFactory = i18NBeanFactory;
        this.intermediateHtmlBuilder = intermediateHtmlBuilder;
        this.flyingPdfDocumentConverter = flyingPdfDocumentConverter;
    }

    @Override
    public File createPdfForSpace(ConfluenceUser user, Space space, ContentTree contentTree, PdfExportProgressMonitor exportProgressMonitor, String contextPath, SpaceExportMetrics spaceExportMetrics, DecorationPolicy decorations) throws ImportExportException {
        this.exportPermissionChecker.checkAuthorization(user, space);
        AbstractPdfExportProgressMonitor progressMonitor = InternalPdfExporterService.progressMonitor(exportProgressMonitor);
        UtilTimerStack.push((String)"intermediateHtmlBuilder.buildHtml");
        Document xhtml = this.intermediateHtmlBuilder.buildHtml(contentTree, space, LinkRenderingDetails.anchors(), DecorationPolicy.space().combine(decorations), progressMonitor);
        UtilTimerStack.pop((String)"intermediateHtmlBuilder.buildHtml");
        contentTree = null;
        String spaceKey = this.getSpaceKeyForExportFileName(space.getKey());
        progressMonitor.beginHtmlToPdfConversion();
        File file = this.flyingPdfDocumentConverter.convertXhtmlToPdf(spaceKey, xhtml, progressMonitor, contextPath);
        spaceExportMetrics.getExportResults().setPdfFileSizeBytes(file.length());
        spaceExportMetrics.getExportResults().setPdfPagesTotal(progressMonitor.numberOfPdfPages);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File createPdfForPage(ConfluenceUser user, AbstractPage page, String contextPath, PageExportMetrics pageExportMetrics) throws ImportExportException {
        long startTime = System.currentTimeMillis();
        try {
            pageExportMetrics.setPageId(page.getId());
            pageExportMetrics.setPageRevision(page.getConfluenceRevision().hashCode());
            DefaultProgressMonitor progressMonitor = new DefaultProgressMonitor();
            File result = this.doCreatePdfForPage(user, page, contextPath, progressMonitor);
            pageExportMetrics.getExportResults().setExportStatus(ExportStatus.OK);
            pageExportMetrics.getExportResults().setPdfPagesTotal(progressMonitor.numberOfPdfPages);
            pageExportMetrics.getExportResults().setPdfFileSizeBytes(result.length());
            File file = result;
            return file;
        }
        finally {
            pageExportMetrics.setTimeMs((int)(System.currentTimeMillis() - startTime));
        }
    }

    private static AbstractPdfExportProgressMonitor progressMonitor(PdfExportProgressMonitor monitor) {
        if (monitor instanceof AbstractPdfExportProgressMonitor) {
            return (AbstractPdfExportProgressMonitor)monitor;
        }
        return new DefaultProgressMonitor(monitor);
    }

    private File doCreatePdfForPage(ConfluenceUser user, AbstractPage page, String contextPath, AbstractPdfExportProgressMonitor progressMonitor) throws ImportExportException {
        Document xhtml;
        this.exportPermissionChecker.checkAuthorization(user, page);
        if (page instanceof Page) {
            ContentTree tree = this.newContentTree();
            tree.addRootNode(new ContentNode((Page)page));
            xhtml = this.intermediateHtmlBuilder.buildHtml(tree, page.getSpace(), LinkRenderingDetails.anchors(), DecorationPolicy.none(), progressMonitor);
        } else if (page instanceof BlogPost) {
            xhtml = this.intermediateHtmlBuilder.buildHtml((BlogPost)page);
        } else {
            throw new IllegalArgumentException("Only pages and blog post are supported");
        }
        return this.flyingPdfDocumentConverter.convertXhtmlToPdf(this.makePdfFilename(page), xhtml, progressMonitor, contextPath);
    }

    private String makePdfFilename(AbstractPage page) {
        String spaceKey = this.getSpaceKeyForExportFileName(page.getSpaceKey());
        String safeName = spaceKey + "-" + page.getId();
        String filename = spaceKey + "-" + Optional.ofNullable(page.getTitle()).map(title -> title.replaceAll("\\s", "")).orElse(String.valueOf(page.getId()));
        if (!FilesystemUtils.isSafeTitleForFilesystem((String)filename)) {
            filename = safeName;
        }
        try {
            Paths.get(filename, new String[0]);
        }
        catch (InvalidPathException ex) {
            filename = safeName;
        }
        return filename;
    }

    protected ContentTree newContentTree() {
        return new ContentTree();
    }

    @Override
    public PdfExportProgressMonitor createProgressMonitor(ProgressMeter progressMeter) {
        return new ProgressMeterWrappingProgressMonitor(this.i18NBeanFactory.getI18NBean(), progressMeter);
    }

    private String getSpaceKeyForExportFileName(String spaceKey) {
        if (spaceKey.startsWith("~")) {
            spaceKey = spaceKey.substring(1);
        }
        return spaceKey;
    }
}

