/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.impl.rpc;

import com.atlassian.confluence.core.ContextPathHolder;
import com.atlassian.confluence.dmz.importexport.LegacyImportExportManager;
import com.atlassian.confluence.extra.flyingpdf.analytic.SpaceExportMetrics;
import com.atlassian.confluence.extra.flyingpdf.impl.DelegatingPdfExporterService;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.persistence.dao.compatibility.FindUserHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import java.io.File;
import java.io.IOException;
import java.util.function.Predicate;
import org.springframework.stereotype.Component;

@Component
public class PdfExportRpcDelegatorImpl {
    private final GateKeeper gateKeeper;
    private final SpaceManager spaceManager;
    private final GlobalSettingsManager settingsManager;
    private final PermissionManager permissionManager;
    private final LegacyImportExportManager importExportManager;
    private final TransactionTemplate transactionTemplate;
    private final ContextPathHolder contextPathHolder;
    private final DelegatingPdfExporterService pdfExporterService;

    public PdfExportRpcDelegatorImpl(@ComponentImport GateKeeper gateKeeper, @ComponentImport SpaceManager spaceManager, @ComponentImport GlobalSettingsManager settingsManager, @ComponentImport PermissionManager permissionManager, @ComponentImport LegacyImportExportManager importExportManager, @ComponentImport TransactionTemplate transactionTemplate, @ComponentImport ContextPathHolder contextPathHolder, DelegatingPdfExporterService pdfExporterService) {
        this.gateKeeper = gateKeeper;
        this.spaceManager = spaceManager;
        this.settingsManager = settingsManager;
        this.permissionManager = permissionManager;
        this.importExportManager = importExportManager;
        this.transactionTemplate = transactionTemplate;
        this.contextPathHolder = contextPathHolder;
        this.pdfExporterService = pdfExporterService;
    }

    public String exportSpace(String spaceKey) throws RemoteException {
        Object obj = this.transactionTemplate.execute(() -> {
            String downloadPath;
            Space space = this.spaceManager.getSpace(spaceKey);
            if (space == null) {
                return new RemoteException("Invalid spaceKey: [" + spaceKey + "]");
            }
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            if (!this.hasPermission(user, space)) {
                return new NotPermittedException("You don't have permission to export the space: " + space.getKey());
            }
            ContentTree contentTree = this.importExportManager.getContentTree((User)user, space);
            try {
                String contextPath = this.contextPathHolder.getContextPath();
                File pdfFile = this.pdfExporterService.createPdfForSpace(user, space, contentTree, contextPath, new SpaceExportMetrics());
                downloadPath = this.importExportManager.prepareDownloadPath(pdfFile.getAbsolutePath());
                Predicate<User> permissionPredicate = u -> this.permissionManager.hasPermission(FindUserHelper.getUser((User)user), Permission.EXPORT, (Object)space);
                this.gateKeeper.addKey(downloadPath, (User)user, permissionPredicate);
            }
            catch (ImportExportException | IOException e) {
                return new RemoteException(e.getMessage());
            }
            return downloadPath;
        });
        if (obj instanceof RemoteException) {
            throw (RemoteException)obj;
        }
        String downloadPath = (String)obj;
        return this.settingsManager.getGlobalSettings().getBaseUrl() + downloadPath;
    }

    private boolean hasPermission(ConfluenceUser user, Space space) {
        return this.permissionManager.hasPermission(user, Permission.EXPORT, (Object)space);
    }
}

