/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.upgrade;

import com.atlassian.confluence.extra.flyingpdf.config.FontManager;
import com.atlassian.confluence.setup.settings.ConfluenceDirectories;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={LifecycleAware.class})
public class UpgradePdfLanguageSupport
implements LifecycleAware {
    private final Logger LOGGER;
    private final FontManager pdfExportFontManager;
    private final ConfluenceDirectories confluenceDirectories;
    private final ApplicationProperties applicationProperties;

    @Autowired
    public UpgradePdfLanguageSupport(@ComponentImport ConfluenceDirectories confluenceDirectories, @ComponentImport ApplicationProperties applicationProperties, FontManager pdfExportFontManager) {
        this(confluenceDirectories, applicationProperties, pdfExportFontManager, LoggerFactory.getLogger(UpgradePdfLanguageSupport.class));
    }

    UpgradePdfLanguageSupport(ConfluenceDirectories confluenceDirectories, ApplicationProperties applicationProperties, FontManager pdfExportFontManager, Logger logger) {
        this.applicationProperties = applicationProperties;
        this.pdfExportFontManager = pdfExportFontManager;
        this.confluenceDirectories = confluenceDirectories;
        this.LOGGER = logger;
    }

    public void onStart() {
        if (this.pdfExportFontManager.isCustomFontInstalled()) {
            return;
        }
        File fontDir = new File(this.applicationProperties.getHomeDirectory(), "fonts");
        if (!fontDir.exists()) {
            return;
        }
        File[] fontFiles = fontDir.listFiles();
        if (fontFiles == null || fontFiles.length == 0) {
            return;
        }
        if (fontFiles.length > 1) {
            this.LOGGER.warn("More than one file was found in the font directory - custom font will not be migrated for use with the PDF Export plugin.");
            return;
        }
        try {
            File tempFontDir = this.confluenceDirectories.getTempDirectory().resolve(String.valueOf(System.currentTimeMillis())).toFile();
            if (!tempFontDir.mkdir()) {
                throw new IOException("Failed to create the temporary font storage directory " + String.valueOf(tempFontDir));
            }
            File tempFontFile = new File(tempFontDir, fontFiles[0].getName());
            if (!fontFiles[0].renameTo(tempFontFile)) {
                throw new IOException("Could not move the currently installed font " + fontFiles[0].getAbsolutePath() + " to a temporary location of " + String.valueOf(tempFontDir));
            }
            this.pdfExportFontManager.installFont((Resource)new FileSystemResource(tempFontFile));
            this.LOGGER.info("Successfully made the font {} available for use in the PDF export plugin.", (Object)fontFiles[0]);
        }
        catch (IOException ex) {
            this.LOGGER.error("Failed to make the font {} available for use in the PDF export plugin. Please install the font manually.", (Object)fontFiles[0], (Object)ex);
        }
    }

    public void onStop() {
    }
}

