/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.util;

import com.atlassian.annotations.Internal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

@Internal
public class UrlUtils {
    public static final Pattern pageDisplayUrlPattern = Pattern.compile("/spaces/([a-zA-Z0-9~+]+)/pages/(\\d+)/([^/\\?]+)([\\?#/]|\\z)");
    private static final String[] URL_ENCODING_EXCEPTIONS_FIND = new String[]{"%40", "%7E"};
    private static final String[] URL_ENCODING_EXCEPTIONS_REPLACE = new String[]{"@", "~"};

    public static String getFullUrl(String baseUrl, String contextPath) {
        String url = baseUrl;
        if (StringUtils.isNotBlank((CharSequence)contextPath)) {
            int i = url.lastIndexOf(contextPath);
            url = i != -1 ? url.substring(0, i) : "";
        }
        return url;
    }

    public static String decode(String title) {
        if (title == null) {
            return null;
        }
        return URLDecoder.decode(title, StandardCharsets.UTF_8);
    }

    public static String encode(String title) {
        if (title == null) {
            return null;
        }
        String s = URLEncoder.encode(title, StandardCharsets.UTF_8);
        return StringUtils.replaceEach((String)s, (String[])URL_ENCODING_EXCEPTIONS_FIND, (String[])URL_ENCODING_EXCEPTIONS_REPLACE);
    }
}

