/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.parser.property;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.parser.CSSParseException;
import org.xhtmlrenderer.css.parser.PropertyValue;
import org.xhtmlrenderer.css.parser.property.AbstractPropertyBuilder;
import org.xhtmlrenderer.css.parser.property.PageSize;
import org.xhtmlrenderer.css.sheet.PropertyDeclaration;
import org.xhtmlrenderer.css.sheet.StylesheetInfo;

public class SizePropertyBuilder
extends AbstractPropertyBuilder {
    private static final CSSName[] ALL = new CSSName[]{CSSName.FS_PAGE_ORIENTATION, CSSName.FS_PAGE_HEIGHT, CSSName.FS_PAGE_WIDTH};
    private static final Set<String> PAGE_ORIENTATIONS = Set.of("landscape", "portrait");
    private static final PropertyValue AUTO = new PropertyValue(IdentValue.AUTO);

    @Override
    public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<? extends CSSPrimitiveValue> values, StylesheetInfo.Origin origin, boolean important, boolean inheritAllowed) {
        ArrayList<PropertyDeclaration> result = new ArrayList<PropertyDeclaration>(3);
        this.assertFoundUpToValues(cssName, values, 3);
        if (values.size() == 1) {
            PropertyValue value = (PropertyValue)values.get(0);
            this.checkInheritAllowed(value, inheritAllowed);
            if (value.getCssValueType() == 0) {
                return this.checkInheritAll(ALL, values, origin, important, inheritAllowed);
            }
            if (value.getPrimitiveType() == 21) {
                PageSize pageSize = PageSize.getPageSize(value.getStringValue());
                if (pageSize != null) {
                    SizePropertyBuilder.addPageSize(result, pageSize.getPageWidth(), pageSize.getPageHeight(), origin, important);
                    return result;
                }
                IdentValue ident = this.checkIdent(value);
                if (ident == IdentValue.LANDSCAPE || ident == IdentValue.PORTRAIT) {
                    SizePropertyBuilder.addPageSize(result, value, AUTO, AUTO, origin, important);
                    return result;
                }
                if (ident == IdentValue.AUTO) {
                    SizePropertyBuilder.addPageSize(result, value, value, value, origin, important);
                    return result;
                }
                throw new CSSParseException("Identifier " + String.valueOf(ident) + " is not a valid value for " + String.valueOf(cssName), -1);
            }
            if (this.isLength(value)) {
                SizePropertyBuilder.addPageSize(result, value, value, origin, important);
                return result;
            }
            throw new CSSParseException("Value for " + String.valueOf(cssName) + " must be a length or identifier", -1);
        }
        if (values.size() == 2) {
            PropertyValue value1 = (PropertyValue)values.get(0);
            PropertyValue value2 = (PropertyValue)values.get(1);
            this.checkInheritAllowed(value2, false);
            if (this.isLength(value1) && this.isLength(value2)) {
                SizePropertyBuilder.addPageSize(result, value1, value2, origin, important);
                return result;
            }
            if (value1.getPrimitiveType() == 21 && value2.getPrimitiveType() == 21) {
                if (PAGE_ORIENTATIONS.contains(value2.getStringValue())) {
                    PropertyValue temp = value1;
                    value1 = value2;
                    value2 = temp;
                }
                SizePropertyBuilder.validatePageOrientation(value1);
                PageSize pageSize = PageSize.getPageSize(value2.getStringValue());
                if (pageSize == null) {
                    throw new CSSParseException("Value " + String.valueOf(value2) + " is not a valid page size", -1);
                }
                SizePropertyBuilder.addPageSize(result, value1, pageSize.getPageWidth(), pageSize.getPageHeight(), origin, important);
                return result;
            }
            throw new CSSParseException("Invalid value for size property", -1);
        }
        if (values.size() == 3) {
            PropertyValue value1 = (PropertyValue)values.get(0);
            PropertyValue value2 = (PropertyValue)values.get(1);
            PropertyValue value3 = (PropertyValue)values.get(2);
            this.checkInheritAllowed(value3, false);
            if (this.isLength(value1) && this.isLength(value2) && value3.getPrimitiveType() == 21) {
                SizePropertyBuilder.validatePageOrientation(value3);
                SizePropertyBuilder.addPageSize(result, value3, value1, value2, origin, important);
                return result;
            }
            throw new CSSParseException("Size property parsing error", -1);
        }
        throw new CSSParseException("Invalid value count for size property", -1);
    }

    private static void addPageSize(List<PropertyDeclaration> result, CSSPrimitiveValue width, CSSPrimitiveValue height, StylesheetInfo.Origin origin, boolean important) {
        SizePropertyBuilder.addPageSize(result, AUTO, width, height, origin, important);
    }

    private static void addPageSize(List<PropertyDeclaration> result, PropertyValue orientation, CSSPrimitiveValue width, CSSPrimitiveValue height, StylesheetInfo.Origin origin, boolean important) {
        if (width instanceof PropertyValue) {
            PropertyValue widthValue = (PropertyValue)width;
            SizePropertyBuilder.validatePageDimension(widthValue);
        }
        if (height instanceof PropertyValue) {
            PropertyValue heightValue = (PropertyValue)height;
            SizePropertyBuilder.validatePageDimension(heightValue);
        }
        result.add(new PropertyDeclaration(CSSName.FS_PAGE_ORIENTATION, orientation, important, origin));
        result.add(new PropertyDeclaration(CSSName.FS_PAGE_WIDTH, width, important, origin));
        result.add(new PropertyDeclaration(CSSName.FS_PAGE_HEIGHT, height, important, origin));
    }

    private static void validatePageDimension(PropertyValue value) {
        if (value.getFloatValue() < 0.0f) {
            throw new CSSParseException("A page dimension may not be negative: " + value.getFloatValue(), -1);
        }
    }

    private static void validatePageOrientation(PropertyValue orientation) {
        if (!PAGE_ORIENTATIONS.contains(orientation.toString())) {
            throw new CSSParseException("Value " + String.valueOf(orientation) + " is not a valid page orientation", -1);
        }
    }
}

