/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.style;

import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.parser.PropertyValue;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.FSDerivedValue;
import org.xhtmlrenderer.css.style.derived.LengthValue;
import org.xhtmlrenderer.css.style.derived.ListValue;

public class BorderRadiusCorner {
    public static final BorderRadiusCorner UNDEFINED = new BorderRadiusCorner(0.0f, 0.0f);
    private final Length _left;
    private final Length _right;

    public BorderRadiusCorner(float left, float right) {
        this._left = new Length(left, false);
        this._right = new Length(right, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BorderRadiusCorner(CSSName fromVal, CalculatedStyle style, CssContext ctx) {
        FSDerivedValue value = style.valueByName(fromVal);
        if (value instanceof ListValue) {
            PropertyValue second;
            ListValue lValues = (ListValue)value;
            PropertyValue first = (PropertyValue)lValues.getValues().get(0);
            PropertyValue propertyValue = second = lValues.getValues().size() > 1 ? (PropertyValue)lValues.getValues().get(1) : first;
            if (fromVal.equals(CSSName.BORDER_TOP_LEFT_RADIUS) || fromVal.equals(CSSName.BORDER_BOTTOM_RIGHT_RADIUS)) {
                this._right = this.calculate(fromVal, style, first, ctx);
                this._left = this.calculate(fromVal, style, second, ctx);
                return;
            } else {
                if (!fromVal.equals(CSSName.BORDER_TOP_RIGHT_RADIUS) && !fromVal.equals(CSSName.BORDER_BOTTOM_LEFT_RADIUS)) throw new IllegalArgumentException("Unknown border radius type: " + String.valueOf(fromVal));
                this._left = this.calculate(fromVal, style, first, ctx);
                this._right = this.calculate(fromVal, style, second, ctx);
            }
            return;
        } else {
            if (!(value instanceof LengthValue)) throw new IllegalArgumentException("Unknown length value: " + String.valueOf(value));
            LengthValue lv = (LengthValue)value;
            this._left = lv.getStringValue().contains("%") ? (this._right = new Length(value.asFloat() / 100.0f, true)) : (this._right = new Length((int)lv.getFloatProportionalTo(fromVal, 0.0f, ctx), false));
        }
    }

    private Length calculate(CSSName fromVal, CalculatedStyle style, PropertyValue value, CssContext ctx) {
        return switch (value.getPrimitiveType()) {
            case 2 -> new Length(value.getFloatValue() / 100.0f, true);
            default -> new Length(LengthValue.calcFloatProportionalValue(style, fromVal, value.getCssText(), value.getFloatValue(), value.getPrimitiveType(), 0.0f, ctx), false);
        };
    }

    public boolean hasRadius() {
        return this._left.value() > 0.0f || this._right.value() > 0.0f;
    }

    public float getMaxLeft(float max) {
        if (this._left.percent()) {
            return max * this._left.value();
        }
        return Math.min(this._left.value(), max);
    }

    public float getMaxRight(float max) {
        if (this._right.percent()) {
            return max * this._right.value();
        }
        return Math.min(this._right.value(), max);
    }

    public float left() {
        return this._left.value();
    }

    public float right() {
        return this._right.value();
    }

    private record Length(float value, boolean percent) {
    }
}

