/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import java.net.URI;
import org.jspecify.annotations.NonNull;
import org.xhtmlrenderer.extend.FSImage;

public class PDFAsImage
implements FSImage {
    private final URI _source;
    private final float _width;
    private final float _height;
    private final float _unscaledWidth;
    private final float _unscaledHeight;

    public PDFAsImage(URI source, float width, float height) {
        this._source = source;
        this._width = width;
        this._unscaledWidth = width;
        this._height = height;
        this._unscaledHeight = height;
    }

    private PDFAsImage(URI source, float unscaledWidth, float unscaledHeight, float width, float height) {
        this._source = source;
        this._width = width;
        this._unscaledWidth = unscaledWidth;
        this._height = height;
        this._unscaledHeight = unscaledHeight;
    }

    @Override
    public int getWidth() {
        return (int)this._width;
    }

    @Override
    public int getHeight() {
        return (int)this._height;
    }

    @Override
    public @NonNull FSImage scale(int width, int height) {
        float targetWidth = width;
        float targetHeight = height;
        if (width == -1) {
            targetWidth = this.getWidthAsFloat() * (targetHeight / (float)this.getHeight());
        }
        if (height == -1) {
            targetHeight = this.getHeightAsFloat() * (targetWidth / (float)this.getWidth());
        }
        return new PDFAsImage(this._source, this._width, this._height, targetWidth, targetHeight);
    }

    public URI getURI() {
        return this._source;
    }

    public float getWidthAsFloat() {
        return this._width;
    }

    public float getHeightAsFloat() {
        return this._height;
    }

    public float getUnscaledHeight() {
        return this._unscaledHeight;
    }

    public float getUnscaledWidth() {
        return this._unscaledWidth;
    }

    public float scaleHeight() {
        return this._height / this._unscaledHeight;
    }

    public float scaleWidth() {
        return this._width / this._unscaledWidth;
    }
}

