/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.pdf.FontDescription;
import org.xhtmlrenderer.pdf.ITextFontResolver;
import org.xhtmlrenderer.util.XRRuntimeException;

public class TrueTypeUtil {
    private static final boolean AVOID_MEMORY_MAPPED_FILES = true;

    private static IdentValue guessStyle(BaseFont font) {
        String[][] names;
        for (String[] name : names = font.getFullFontName()) {
            String lower = name[3].toLowerCase(Locale.ROOT);
            if (lower.contains("italic")) {
                return IdentValue.ITALIC;
            }
            if (!lower.contains("oblique")) continue;
            return IdentValue.OBLIQUE;
        }
        return IdentValue.NORMAL;
    }

    public static Collection<String> getFamilyNames(BaseFont font) {
        String[][] names = font.getFamilyFontName();
        if (names.length == 1) {
            return Collections.singletonList(names[0][3]);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String[] name : names) {
            if ((!name[0].equals("1") || !name[1].equals("0")) && !name[2].equals("1033")) continue;
            result.add(name[3]);
        }
        return result;
    }

    private static Map<String, int[]> extractTables(BaseFont font) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        for (Class<?> current = font.getClass(); current != null; current = current.getSuperclass()) {
            if (!current.getName().endsWith(".TrueTypeFont")) continue;
            Field field = current.getDeclaredField("tables");
            field.setAccessible(true);
            return (Map)field.get(font);
        }
        throw new NoSuchFieldException("Could not find tables field");
    }

    private static String getTTCName(String name) {
        int index = name.toLowerCase(Locale.ROOT).indexOf(".ttc,");
        return index < 0 ? name : name.substring(0, index + 4);
    }

    public static FontDescription extractDescription(String path, BaseFont font, @Nullable IdentValue fontWeightOverride) {
        try {
            FontDescription.Decorations decorations = TrueTypeUtil.readFontDecorations(path, font, fontWeightOverride);
            return new FontDescription(font, false, TrueTypeUtil.guessStyle(font), decorations);
        }
        catch (DocumentException | IOException | IllegalAccessException | NoSuchFieldException e) {
            throw new XRRuntimeException("Failed to read font description from %s".formatted(path), e);
        }
    }

    private static FontDescription.Decorations readFontDecorations(String path, BaseFont font, @Nullable IdentValue fontWeightOverride) throws IOException, NoSuchFieldException, IllegalAccessException, DocumentException {
        try (RandomAccessFileOrArray rf = new RandomAccessFileOrArray(TrueTypeUtil.getTTCName(path), false, true);){
            FontDescription.Decorations decorations = TrueTypeUtil.readFontDecorations(path, font, rf, fontWeightOverride);
            return decorations;
        }
    }

    public static FontDescription extractDescription(String path, byte[] contents, BaseFont font, boolean isFromFontFace, @Nullable IdentValue fontWeightOverride, @Nullable IdentValue fontStyleOverride) {
        try {
            IdentValue style = Objects.requireNonNullElseGet(fontStyleOverride, () -> TrueTypeUtil.guessStyle(font));
            FontDescription.Decorations decorations = TrueTypeUtil.readFontDecorations(path, contents, font, fontWeightOverride);
            return new FontDescription(font, isFromFontFace, style, decorations);
        }
        catch (IOException | IllegalAccessException | NoSuchFieldException e) {
            throw new XRRuntimeException("Failed to read font description from %s".formatted(path), e);
        }
    }

    private static FontDescription.Decorations readFontDecorations(String path, byte[] contents, BaseFont font, @Nullable IdentValue fontWeightOverride) throws IOException, NoSuchFieldException, IllegalAccessException, DocumentException {
        try (RandomAccessFileOrArray rf = new RandomAccessFileOrArray(contents);){
            FontDescription.Decorations decorations = TrueTypeUtil.readFontDecorations(path, font, rf, fontWeightOverride);
            return decorations;
        }
    }

    private static FontDescription.Decorations readFontDecorations(String path, BaseFont font, RandomAccessFileOrArray rf, @Nullable IdentValue fontWeightOverride) throws NoSuchFieldException, IllegalAccessException, DocumentException, IOException {
        Map<String, int[]> tables = TrueTypeUtil.extractTables(font);
        int[] location = tables.get("OS/2");
        if (location == null) {
            throw new DocumentException("Table 'OS/2' does not exist in " + path);
        }
        rf.seek(location[0]);
        int want = 4;
        long got = rf.skip(want);
        if (got < (long)want) {
            throw new DocumentException("Skip TT font weight, expect read " + want + " bytes, but only got " + got);
        }
        int fontWeight = rf.readUnsignedShort();
        int weight = Optional.ofNullable(fontWeightOverride).map(w -> ITextFontResolver.convertWeightToInt(w)).orElse(fontWeight);
        want = 20;
        got = rf.skip(want);
        if (got < (long)want) {
            throw new DocumentException("Skip TT font strikeout, expect read " + want + " bytes, but only got " + got);
        }
        float yStrikeoutSize = rf.readShort();
        float yStrikeoutPosition = rf.readShort();
        float underlinePosition = 0.0f;
        float underlineThickness = 0.0f;
        location = tables.get("post");
        if (location != null) {
            rf.seek(location[0]);
            want = 8;
            got = rf.skip(want);
            if (got < (long)want) {
                throw new DocumentException("Skip TT font underline, expect read " + want + " bytes, but only got " + got);
            }
            underlinePosition = rf.readShort();
            underlineThickness = rf.readShort();
        }
        return new FontDescription.Decorations(weight, yStrikeoutSize, yStrikeoutPosition, underlinePosition, underlineThickness);
    }
}

