/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.audit;

import com.atlassian.audit.core.spi.service.IpAddressProvider;
import com.atlassian.confluence.util.RequestCacheThreadLocal;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ConfluenceAuditIpAddressProvider
implements IpAddressProvider {
    public @Nullable String currentIpAddress() {
        String proxyAddresses = RequestCacheThreadLocal.getXForwardedFor();
        String remoteAddress = RequestCacheThreadLocal.getRemoteAddress();
        if (proxyAddresses == null && remoteAddress == null) {
            return null;
        }
        return Stream.of(proxyAddresses, remoteAddress).filter(Objects::nonNull).collect(Collectors.joining(", "));
    }

    public @Nullable String remoteIpAddress() {
        return RequestCacheThreadLocal.getRemoteAddress();
    }

    public @NonNull Optional<String> forwarderIpAddress() {
        return Optional.ofNullable(RequestCacheThreadLocal.getXForwardedFor());
    }
}

