/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.audit.uri;

import com.atlassian.confluence.api.impl.service.audit.uri.ResourceUriGenerator;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.Entity;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.web.util.UriComponentsBuilder;

public class GroupUriGenerator
implements ResourceUriGenerator {
    private final UserAccessor userAccessor;

    public GroupUriGenerator(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Override
    public Map<String, URI> generate(URI baseUrl, Set<String> identifiers) {
        List groupNames = identifiers.stream().collect(Collectors.toList());
        return this.userAccessor.getGroupsByGroupNames(groupNames).stream().map(Entity::getName).filter(Objects::nonNull).filter(identifiers::contains).collect(Collectors.toMap(group -> group, group -> this.groupUri(baseUrl, (String)group)));
    }

    private @NonNull URI groupUri(URI baseUrl, String group) {
        return UriComponentsBuilder.fromUri((URI)baseUrl).pathSegment(new String[]{"admin", "users", "domembersofgroupsearch.action"}).queryParam("membersOfGroupTerm", new Object[]{group}).build().toUri();
    }
}

