/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.cloud.connect.companion.client;

import com.atlassian.plugins.cloud.connect.companion.client.CloudContext;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestMethod;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class CloudRequest<T> {
    private final CloudRequestMethod method;
    private final URL url;
    private final CloudContext cloudContext;
    private final Map<String, String> headers;
    private final T body;

    private CloudRequest(CloudRequestMethod method, URL url, CloudContext cloudContext, Map<String, String> headers, T body) {
        this.method = method;
        this.url = url;
        this.cloudContext = cloudContext;
        this.headers = Collections.unmodifiableMap(new HashMap<String, String>(headers));
        this.body = body;
    }

    public static <T> MethodCollector<T> builder(T body) {
        return new CloudRequestBuilder<T>(body);
    }

    public static <T> MethodCollector<T> builder() {
        return new CloudRequestBuilder();
    }

    public CloudRequestMethod getMethod() {
        return this.method;
    }

    public URL getUrl() {
        return this.url;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public CloudContext getCloudContext() {
        return this.cloudContext;
    }

    public Optional<T> getBody() {
        return Optional.ofNullable(this.body);
    }

    public static class CloudRequestBuilder<T>
    implements MethodCollector<T>,
    URLCollector<T>,
    HeaderCollector<T>,
    CloudContextCollector<T> {
        private CloudRequestMethod method;
        private URL url;
        private CloudContext cloudContext;
        private final T body;
        private final Map<String, String> headers = new HashMap<String, String>();

        private CloudRequestBuilder(T body) {
            this.body = body;
        }

        private CloudRequestBuilder() {
            this.body = null;
        }

        @Override
        public HeaderCollector<T> header(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        @Override
        public CloudRequest<T> build() {
            return new CloudRequest<T>(this.method, this.url, this.cloudContext, this.headers, this.body);
        }

        @Override
        public URLCollector<T> method(CloudRequestMethod method) {
            this.method = method;
            return this;
        }

        @Override
        public CloudContextCollector<T> url(URL url) {
            this.url = url;
            return this;
        }

        @Override
        public HeaderCollector<T> cloudContext(CloudContext cloudContext) {
            this.cloudContext = cloudContext;
            return this;
        }
    }

    public static interface HeaderCollector<T> {
        public HeaderCollector<T> header(String var1, String var2);

        public CloudRequest<T> build();
    }

    public static interface CloudContextCollector<T> {
        public HeaderCollector<T> cloudContext(CloudContext var1);
    }

    public static interface URLCollector<T> {
        public CloudContextCollector<T> url(URL var1);
    }

    public static interface MethodCollector<T> {
        public URLCollector<T> method(CloudRequestMethod var1);
    }
}

