/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.confluence;

import com.atlassian.core.task.AbstractErrorQueuedTaskQueue;
import com.atlassian.core.task.ErrorQueuedTaskQueue;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.core.task.TaskQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.troubleshooting.healthcheck.checks.mailqueue.ApplicationMailQueue;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public class ConfluenceMailQueue
implements ApplicationMailQueue {
    private static final String MAIL_QUEUE_NAME = "mail";
    private final MultiQueueTaskManager taskManager;

    public ConfluenceMailQueue(MultiQueueTaskManager taskManager) {
        this.taskManager = taskManager;
    }

    @Override
    public Collection<MailQueueItem> getMailQueueItems() {
        return this.taskManager.getTaskQueue(MAIL_QUEUE_NAME).getTasks().stream().map(this::taskToMailQueueItem).filter(Objects::nonNull).toList();
    }

    @Override
    public boolean isSending() {
        return this.taskManager.getTaskQueue(MAIL_QUEUE_NAME).isFlushing();
    }

    @Override
    public int size() {
        return this.taskManager.getTaskQueue(MAIL_QUEUE_NAME).getTasks().size();
    }

    @Override
    public int errorSize() {
        return this.getErrorTaskQueue().map(AbstractErrorQueuedTaskQueue::getErrorQueue).map(TaskQueue::size).orElse(0);
    }

    @Nullable
    private MailQueueItem taskToMailQueueItem(Task task) {
        if ((task = this.unwrapTaskDecorator(task)) instanceof MailQueueItem) {
            MailQueueItem mailQueueItem = (MailQueueItem)task;
            return mailQueueItem;
        }
        return null;
    }

    private Task unwrapTaskDecorator(Task task) {
        if (task instanceof AbstractErrorQueuedTaskQueue.TaskDecorator) {
            AbstractErrorQueuedTaskQueue.TaskDecorator taskDecorator = (AbstractErrorQueuedTaskQueue.TaskDecorator)task;
            return taskDecorator.getTask();
        }
        return task;
    }

    private Optional<ErrorQueuedTaskQueue> getErrorTaskQueue() {
        TaskQueue taskQueue = this.taskManager.getTaskQueue(MAIL_QUEUE_NAME);
        if (taskQueue instanceof ErrorQueuedTaskQueue) {
            ErrorQueuedTaskQueue errorQueuedTaskQueue = (ErrorQueuedTaskQueue)taskQueue;
            return Optional.of(errorQueuedTaskQueue);
        }
        return Optional.empty();
    }
}

