/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.confluence.bundle;

import com.atlassian.confluence.setup.settings.CustomHtmlSettings;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.themes.CustomLayoutManager;
import com.atlassian.confluence.themes.StylesheetManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.troubleshooting.stp.salext.bundle.BundleManifest;
import com.atlassian.troubleshooting.stp.salext.bundle.CustomisationFileBundle;
import java.util.HashMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ConfluenceCustomisationFileBundle
extends CustomisationFileBundle {
    private final SpaceManager spaceManager;
    private final StylesheetManager stylesheetManager;
    private final GlobalSettingsManager globalSettingsManager;
    private final CustomLayoutManager customLayoutManager;

    @Autowired
    public ConfluenceCustomisationFileBundle(I18nResolver i18nResolver, SpaceManager spaceManager, StylesheetManager stylesheetManager, GlobalSettingsManager globalSettingsManager, CustomLayoutManager customLayoutManager) {
        super(BundleManifest.CONF_CUSTOMISATIONS, "stp.zip.include.confluence.cust", "stp.zip.include.confluence.cust.description", i18nResolver);
        this.spaceManager = spaceManager;
        this.stylesheetManager = stylesheetManager;
        this.globalSettingsManager = globalSettingsManager;
        this.customLayoutManager = customLayoutManager;
    }

    @Override
    protected TreeMap<String, String> getCustomDecorators() {
        TreeMap<String, String> customDecorators = new TreeMap<String, String>();
        this.customLayoutManager.getCustomGlobalDecorators().forEach(dec -> customDecorators.put(String.format("Global customised layout - %s", dec.getName().replace("/", "-")), dec.getBody()));
        this.spaceManager.getAllSpaces().forEach(space -> this.customLayoutManager.getCustomSpaceDecorators(space.getKey()).forEach(dec -> customDecorators.put(String.format("Space %s customised layout - %s", space.getName(), dec.getName().replace("/", "-")), dec.getBody())));
        return customDecorators;
    }

    @Override
    protected HashMap<String, String> getCustomHtml() {
        HashMap<String, String> customHtml = new HashMap<String, String>();
        CustomHtmlSettings customHtmlSettings = new CustomHtmlSettings(this.globalSettingsManager.getGlobalSettings().getCustomHtmlSettings());
        String headHtml = customHtmlSettings.getBeforeHeadEnd();
        String bodyStartHtml = customHtmlSettings.getAfterBodyStart();
        String bodyEndHtml = customHtmlSettings.getBeforeBodyEnd();
        if (!headHtml.isEmpty()) {
            customHtml.put("Before HEAD end", headHtml);
        }
        if (!bodyStartHtml.isEmpty()) {
            customHtml.put("After BODY start", bodyStartHtml);
        }
        if (!bodyEndHtml.isEmpty()) {
            customHtml.put("Before BODY end", bodyEndHtml);
        }
        return customHtml;
    }

    @Override
    protected HashMap<String, String> getCustomStylesheet() {
        HashMap<String, String> customStylesheet = new HashMap<String, String>();
        String globalStylesheet = this.stylesheetManager.getGlobalStylesheet();
        if (StringUtils.isNotEmpty((CharSequence)globalStylesheet)) {
            customStylesheet.put("Global Custom Stylesheet", globalStylesheet);
        }
        this.spaceManager.getAllSpaces().forEach(space -> {
            String spaceStylesheet = this.stylesheetManager.getSpaceStylesheet(space.getKey(), false);
            if (StringUtils.isNotEmpty((CharSequence)spaceStylesheet)) {
                customStylesheet.put("Global Space " + space.getName() + " custom stylesheet", spaceStylesheet);
            }
        });
        return customStylesheet;
    }
}

