/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.confluence.dcdp.provider;

import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.status.service.systeminfo.UsageInfo;
import com.atlassian.troubleshooting.dcdp.transfer.data.provider.GuardrailsProductDataProvider;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;

public class ConfluenceGuardrailsProductDataProvider
implements GuardrailsProductDataProvider {
    @VisibleForTesting
    static final String INDEX_SIZE_LABEL = "Index Size";
    @VisibleForTesting
    static final String SPACES_LABEL = "Spaces";
    private final SystemInformationService systemInformationService;

    public ConfluenceGuardrailsProductDataProvider(SystemInformationService systemInformationService) {
        this.systemInformationService = systemInformationService;
    }

    @Override
    public Map<String, String> getGuardrailsData() {
        UsageInfo usageInfo = this.systemInformationService.getUsageInfo();
        HashMap<String, String> guardrailsData = new HashMap<String, String>();
        if (usageInfo != null) {
            guardrailsData.put("Users", String.valueOf(usageInfo.getLocalUsers()));
            guardrailsData.put("Groups", String.valueOf(usageInfo.getLocalGroups()));
            guardrailsData.put(SPACES_LABEL, String.valueOf(usageInfo.getTotalSpaces()));
            guardrailsData.put(INDEX_SIZE_LABEL, String.valueOf(usageInfo.getCurrentContent()));
        }
        return guardrailsData;
    }
}

