/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.confluence.healthcheck;

import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.license.exception.LicenseException;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheckSupplier;
import com.atlassian.troubleshooting.healthcheck.model.LicenseDetails;
import com.atlassian.troubleshooting.healthcheck.model.LicenseUserLimitCheckType;
import com.atlassian.troubleshooting.healthcheck.persistence.LicenseUserLimitConfigurationStore;
import com.atlassian.troubleshooting.healthcheck.service.AbstractLicenseUserLimitService;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;

public class ConfluenceLicenseUserLimitService
extends AbstractLicenseUserLimitService {
    private static final Logger LOG = Logger.getLogger(ConfluenceLicenseUserLimitService.class.getName());
    private final LicenseService licenseService;
    private final UserChecker userChecker;

    public ConfluenceLicenseUserLimitService(DarkFeatureManager darkFeatureManager, LicenseService licenseService, LicenseUserLimitConfigurationStore licenseUserLimitConfigurationStore, SupportHealthCheckSupplier supportHealthCheckSupplier, UserChecker userChecker) {
        super(darkFeatureManager, licenseUserLimitConfigurationStore, supportHealthCheckSupplier);
        this.licenseService = Objects.requireNonNull(licenseService);
        this.userChecker = Objects.requireNonNull(userChecker);
    }

    @Override
    protected LicenseUserLimitCheckType getCheckType() {
        return LicenseUserLimitCheckType.CONFLUENCE;
    }

    @Override
    public Optional<LicenseDetails> getLicenseDetails() {
        try {
            ConfluenceLicense license = this.licenseService.retrieve();
            Integer numberOfSeats = license.getMaximumNumberOfUsers();
            Integer numberOfTakenSeats = this.userChecker.getNumberOfRegisteredUsers();
            return Optional.of(new LicenseDetails(numberOfSeats, numberOfTakenSeats));
        }
        catch (LicenseException e) {
            LOG.warning("Failed to retrieve license details: " + e.getMessage());
            return Optional.empty();
        }
    }
}

