/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.confluence.healthcheck.backup;

import com.atlassian.confluence.setup.settings.ConfluenceDirectories;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.troubleshooting.api.ClusterService;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import com.atlassian.troubleshooting.healthcheck.checks.AbstractBackupHealthCheck;
import java.nio.file.Path;
import java.util.List;

public class ConfluenceBackupHealthCheck
extends AbstractBackupHealthCheck {
    private final GlobalSettingsManager globalSettingsManager;
    private final ApplicationProperties applicationProperties;
    private final ConfluenceDirectories confluenceDirectories;
    private final String[] prefixes;

    public ConfluenceBackupHealthCheck(GlobalSettingsManager globalSettingsManager, ApplicationProperties applicationProperties, ClusterService clusterService, SupportHealthStatusBuilder statusBuilder, I18nResolver i18nResolver, ConfluenceDirectories confluenceDirectories) {
        super(clusterService, statusBuilder, i18nResolver);
        this.globalSettingsManager = globalSettingsManager;
        this.applicationProperties = applicationProperties;
        this.confluenceDirectories = confluenceDirectories;
        this.prefixes = new String[]{"xmlexport-", this.getUserSiteBackupPrefix()};
    }

    @Override
    protected void checkImpl(List<String> failures) {
        this.checkDirectory(failures, this.globalSettingsManager.getGlobalSettings().getBackupPath());
        this.checkDirectory(failures, this.tempPath(), ConfluenceBackupHealthCheck.findZipsByPrefixes(this.tempPath(), this.prefixes));
        this.applicationProperties.getLocalHomeDirectory().ifPresent(localHome -> this.checkDirectory(failures, this.restoreSitePath((Path)localHome)));
        this.applicationProperties.getSharedHomeDirectory().ifPresent(sharedHome -> this.checkDirectory(failures, this.restoreSitePath((Path)sharedHome)));
    }

    private String restoreSitePath(Path homePath) {
        return homePath.resolve("restore").resolve("site").toAbsolutePath().toString();
    }

    private String tempPath() {
        return this.confluenceDirectories.getTempDirectory().toAbsolutePath().toString();
    }

    private String getUserSiteBackupPrefix() {
        return System.getProperty("confluence.backup.site-backup-filename-prefix", this.i18nResolver.getText("export.page.filename"));
    }
}

