/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.confluence.healthcheck.conditions;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheckCondition;
import jakarta.annotation.Nullable;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class LuceneSearchPlatformCondition
implements SupportHealthCheckCondition {
    protected static final String SEARCH_PLATFORM_KEY = "search.platform";
    protected static final String LUCENE_PLATFORM = "lucene";
    private final ApplicationConfiguration applicationConfig;

    @Autowired
    public LuceneSearchPlatformCondition(ApplicationConfiguration applicationConfig) {
        this.applicationConfig = applicationConfig;
    }

    @Override
    public boolean shouldDisplay() {
        return !Optional.ofNullable(this.getSearchPlatform()).filter(platform -> !StringUtils.equalsIgnoreCase((CharSequence)LUCENE_PLATFORM, (CharSequence)platform)).isPresent();
    }

    @Nullable
    private String getSearchPlatform() {
        return Optional.ofNullable(System.getProperty(SEARCH_PLATFORM_KEY)).orElse((String)this.applicationConfig.getProperty((Object)SEARCH_PLATFORM_KEY));
    }
}

