/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.confluence.healthcheck.database.mysql;

import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.troubleshooting.api.healthcheck.DatabaseService;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthStatus;
import com.atlassian.troubleshooting.confluence.healthcheck.common.Version;
import com.atlassian.troubleshooting.confluence.healthcheck.database.mysql.AbstractMySQLCheck;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import com.google.common.annotations.VisibleForTesting;
import org.springframework.beans.factory.annotation.Autowired;

public class CharacterSetCheck
extends AbstractMySQLCheck {
    @VisibleForTesting
    static final String DATABASE_CHARACTER_SET_QUERY = "SELECT DEFAULT_CHARACTER_SET_NAME FROM information_schema.SCHEMATA S\nWHERE schema_name = ?\nAND DEFAULT_CHARACTER_SET_NAME NOT IN (%s);";
    @VisibleForTesting
    static final String TABLE_CHARACTER_SET_QUERY = "SELECT CCSA.character_set_name FROM information_schema.`TABLES` T,\n information_schema.`COLLATION_CHARACTER_SET_APPLICABILITY` CCSA\n WHERE CCSA.collation_name = T.table_collation\n AND T.table_schema = ? AND character_set_name NOT IN (%s);";
    @VisibleForTesting
    static final String COLUMN_CHARACTER_SET_QUERY = "SELECT TABLE_NAME, COLUMN_NAME, CHARACTER_SET_NAME\nFROM information_schema.COLUMNS\nWHERE TABLE_SCHEMA = ?\nAND CHARACTER_SET_NAME NOT IN (%s);";
    private static final String[] CHARSET_PRIOR_7_2 = new String[]{"utf8"};
    private static final String[] CHARSET_LATER_7_3 = new String[]{"utf8", "utf8mb3", "utf8mb4"};
    private static final Version CONFLUENCE_7_3 = new Version("7.3");
    private final SupportHealthStatusBuilder supportHealthStatusBuilder;
    private final SystemInformationService systemInformationService;

    @Autowired
    public CharacterSetCheck(DatabaseService databaseService, SupportHealthStatusBuilder supportHealthStatusBuilder, SystemInformationService systemInformationService) {
        super(databaseService);
        this.supportHealthStatusBuilder = supportHealthStatusBuilder;
        this.systemInformationService = systemInformationService;
    }

    @Override
    public SupportHealthStatus check() {
        String[] supportedCharsets = this.getSupportedCharsets();
        return this.databaseService.runInConnection(connection -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[TRYBLOCK]], but top level block is 27[DOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    private String[] getSupportedCharsets() {
        Version currentConfluenceVersion = new Version(this.systemInformationService.getConfluenceInfo().getVersion());
        if (currentConfluenceVersion.isLowerThan(CONFLUENCE_7_3)) {
            return CHARSET_PRIOR_7_2;
        }
        return CHARSET_LATER_7_3;
    }
}

