/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.confluence.healthcheck.directory.internal;

import com.atlassian.confluence.user.ConfluenceAuthenticator;
import com.atlassian.confluence.user.ConfluenceCrowdSSOAuthenticator;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.troubleshooting.api.healthcheck.DatabaseService;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheck;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthStatus;
import com.atlassian.troubleshooting.confluence.healthcheck.analytics.InternalAdminCheckFallbackEvent;
import com.atlassian.troubleshooting.confluence.healthcheck.directory.internal.AuthenticatorProvider;
import com.atlassian.troubleshooting.confluence.healthcheck.directory.internal.InternalAdminCheckFallback;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class InternalAdminCheck
implements SupportHealthCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalAdminCheck.class);
    private static final char ACTIVE = 'T';
    private static final List<String> ADMINISTRATOR_PERM_TYPES = Arrays.asList("ADMINISTRATECONFLUENCE", "SYSTEMADMINISTRATOR");
    private final CrowdDirectoryService crowdDirectoryService;
    private final DatabaseService databaseService;
    private final SupportHealthStatusBuilder supportHealthStatusBuilder;
    private final InternalAdminCheckFallback internalAdminCheckFallback;
    private final EventPublisher eventPublisher;
    private final AuthenticatorProvider authenticatorProvider;

    @Autowired
    public InternalAdminCheck(CrowdDirectoryService crowdDirectoryService, DatabaseService databaseService, SupportHealthStatusBuilder supportHealthStatusBuilder, InternalAdminCheckFallback internalAdminCheckFallback, AuthenticatorProvider authenticatorProvider, EventPublisher eventPublisher) {
        this.databaseService = databaseService;
        this.supportHealthStatusBuilder = supportHealthStatusBuilder;
        this.crowdDirectoryService = crowdDirectoryService;
        this.internalAdminCheckFallback = internalAdminCheckFallback;
        this.eventPublisher = eventPublisher;
        this.authenticatorProvider = authenticatorProvider;
    }

    @Override
    public boolean isNodeSpecific() {
        return false;
    }

    @Override
    public SupportHealthStatus check() {
        Authenticator authenticator = this.authenticatorProvider.getAuthenticator();
        if (authenticator instanceof ConfluenceCrowdSSOAuthenticator) {
            return this.supportHealthStatusBuilder.ok(this, "confluence.healthcheck.directory.internal.sso.present", new Serializable[0]);
        }
        if (!(authenticator instanceof ConfluenceAuthenticator)) {
            return this.supportHealthStatusBuilder.ok(this, "confluence.healthcheck.directory.internal.custom.authenticator", new Serializable[0]);
        }
        boolean hasInternalDirectory = this.crowdDirectoryService.findAllDirectories().stream().anyMatch(directory -> directory.getType() == DirectoryType.INTERNAL && directory.isActive());
        if (!hasInternalDirectory) {
            return this.supportHealthStatusBuilder.major(this, "confluence.healthcheck.directory.internal.has.internal.dir.fail", new Serializable[0]);
        }
        try {
            int users = this.databaseService.runInConnection(this::countUsersInAdminGroupQuery);
            if (users == 0 && (users = this.databaseService.runInConnection(this::countUsersWithAdminPermissionQuery).intValue()) == 0) {
                return this.supportHealthStatusBuilder.major(this, "confluence.healthcheck.directory.internal.admin.fail", new Serializable[0]);
            }
        }
        catch (Exception ex) {
            LOGGER.error("An error occurred when performing the Internal Administrator User health check, we're going to try to fallback: ", (Throwable)ex);
            this.eventPublisher.publish((Object)new InternalAdminCheckFallbackEvent());
            return this.internalAdminCheckFallback.check();
        }
        return this.supportHealthStatusBuilder.ok(this, "confluence.healthcheck.directory.internal.admin.ok", new Serializable[0]);
    }

    private int countUsersInAdminGroupQuery(Connection connection) {
        String query = String.format("SELECT COUNT(DISTINCT cwd_user.user_name) FROM cwd_membership cm LEFT OUTER JOIN cwd_user ON cm.child_user_id = cwd_user.id LEFT OUTER JOIN cwd_group ON cm.parent_id = cwd_group.id LEFT OUTER JOIN cwd_directory ON cwd_directory.id = cwd_group.directory_id WHERE cwd_group.lower_group_name IN (SELECT sp.PERMGROUPNAME FROM SPACEPERMISSIONS sp WHERE sp.PERMTYPE IN (%s)) AND cwd_user.active = ? AND cwd_group.active = ? AND cwd_directory.directory_type = ?", ADMINISTRATOR_PERM_TYPES.stream().map(v -> "?").collect(Collectors.joining(",")));
        ArrayList<String> params = new ArrayList<String>(ADMINISTRATOR_PERM_TYPES);
        params.add(Character.toString('T'));
        params.add(Character.toString('T'));
        params.add(DirectoryType.INTERNAL.name());
        return this.getQueryResult(connection, query, params);
    }

    private int countUsersWithAdminPermissionQuery(Connection connection) {
        String query = String.format("SELECT COUNT(DISTINCT cu.user_name) FROM cwd_user cu LEFT OUTER JOIN cwd_directory ON cu.directory_id = cwd_directory.id WHERE cu.user_name IN (SELECT user_mapping.username FROM SPACEPERMISSIONS sp LEFT OUTER JOIN user_mapping ON user_mapping.user_key = sp.PERMUSERNAME WHERE sp.PERMTYPE IN (%s)) AND cu.active = ? AND cwd_directory.directory_type = ?", ADMINISTRATOR_PERM_TYPES.stream().map(v -> "?").collect(Collectors.joining(",")));
        ArrayList<String> params = new ArrayList<String>(ADMINISTRATOR_PERM_TYPES);
        params.add(Character.toString('T'));
        params.add(DirectoryType.INTERNAL.name());
        return this.getQueryResult(connection, query, params);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private int getQueryResult(Connection connection, String query, List<String> params) {
        try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
            int n;
            block15: {
                for (int index = 0; index < params.size(); ++index) {
                    preparedStatement.setString(index + 1, params.get(index));
                }
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    int n2 = n = resultSet.next() ? resultSet.getInt(1) : 0;
                    if (resultSet == null) break block15;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return n;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

